var Service = require('Service');
var utils = require('utils');
var util = require('util');

/**
 * 获得外网设置信息
 */
var GetInternetInfo = function () {
    Service.call(this);
};

util.inherits(GetInternetInfo, Service);

module.exports = GetInternetInfo;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetInternetInfo.prototype.process = function (req, res) {

    var self = this;
    req.session.cache.getCurOrg(function (org) {
        var ts = (new Date()).getTime();
        var ivData = [org.code, org.auth_key, ts];
        var iv = utils.md5(JSON.stringify(ivData)).substr(0, 16);
        ivData.push(iv);
        var key = utils.md5(JSON.stringify(ivData));
        var data = utils.encryptAES(JSON.stringify(ivData), key, iv);

        self.sendHttpRequest({
            "urlPath": "http://om.taskmsg.com/Service",
            "method": "post",
            "headers": {
                "Content-Type": "application/x-www-form-urlencoded"
            },
            "postdata": {
                "service": "om/service/organize/getServerConfig",
                "orgCode": org.code,
                "ts": ts,
                "data": data
            }
        },
        function (reqHttp, resHttp, errHttp, retHttp) {
            if (errHttp) {
                self.onLogicError(1, '查询外网设置信息失败，错误描述：' + errHttp.message);
                return;
            }
            if(!retHttp || (retHttp+"").indexOf("{")!=0) {
                self.onLogicError(1, '查询外网设置信息失败，平台返回信息格式有误！');
                return;
            }
            let retObj = JSON.parse(retHttp);
            if(retObj.code!=0) {
                self.onLogicError(1, '查询外网设置信息失败，错误描述：' + retObj.message);
                return;
            }
            res.serverConfig = retObj.serverConfig;
            self.end(res);
        });
    });
};