var Service = require('Service');
var utils = require('utils');
var ScheduledTask = require('../../dao/scheduled_task');
var util = require('util');

/**
 * 列表
 */
var GetList = function() { 
  Service.call(this);
};

util.inherits(GetList, Service);

module.exports = GetList;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetList.prototype.process =  function(req, res) {
  var self = this;
  var dao = new ScheduledTask(this);
  dao.query({where: 'org_id='+req.session.orgId}, function(rows) {
    res.tasks = rows;
    self.end(res);
  });
};