var Service = require('Service');
var utils = require('utils');
var ScheduledTask = require('../../dao/scheduled_task');
var util = require('util');

/**
 * 列表
 */
var Get = function() { 
  Service.call(this);
};

util.inherits(Get, Service);

module.exports = Get;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
Get.prototype.process =  function(req, res) {
  if(!req.id) {
    this.onLogicError(1, '请提供任务编号！');
    return;
  }
  if(!utils.isInt(req.id)) {
    this.onLogicError(2, '请提供正确的任务编号！');
    return;
  }

  var self = this;
  var dao = new ScheduledTask(this);
  dao.query({where: 'org_id='+req.session.orgId+' and id='+req.id}, function(rows) {
    res.task = rows[0];
    self.end(res);
  });
};