var Service = require('Service');
var utils = require('utils');
var ScheduledTask = require('../../dao/scheduled_task');
var util = require('util');

/**
 * 修改
 */
var Enable = function() { 
  Service.call(this);
};

util.inherits(Enable, Service);

module.exports = Enable;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
Enable.prototype.process =  function(req, res) {
  if(!req.id) {
    this.onLogicError(1, '请提供任务编号！');
    return;
  }
//   if(!utils.isInt(req.id)) {
//     this.onLogicError(2, '请提供正确的任务编号！');
//     return;
//   }
  var self = this;
  var dao = new ScheduledTask(this);
  dao.update({status: 0}, {where: 'id in ('+req.id+') and org_id='+req.session.orgId}, function() {
    if(!global.server.scheduleTaskManager.tasks[req.id]) {
      dao.query({where: 'id in ('+req.id+') and org_id='+req.session.orgId},function(rows) {
        if(rows.length==0) {
          self.end(res);
          return;
        }
        global.server.scheduleTaskManager.tasks[req.id] = rows[0];
        self.end(res);
      });
    } else {
      global.server.scheduleTaskManager.tasks[req.id].status = 0;
      self.end(res);
    }
  });
};