var Service = require('Service');
var utils = require('utils');
var ScheduledTask = require('../../dao/scheduled_task');
var util = require('util');

/**
 * 删除
 */
var Delete = function() { 
  Service.call(this);
};

util.inherits(Delete, Service);

module.exports = Delete;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
Delete.prototype.process =  function(req, res) {
  if(!req.id) {
    this.onLogicError(1, '请提供任务编号！');
    return;
  }
  if(!utils.isInt(req.id)) {
    this.onLogicError(2, '请提供正确的任务编号！');
    return;
  }

  var self = this;
  var dao = new ScheduledTask(this);
  dao.delete('org_id='+req.session.orgId+' and id='+req.id, function() {
    delete global.server.scheduleTaskManager.tasks[req.id];
    self.end(res);
  });
};