var Service = require('Service');
var utils = require('utils');
var ScheduledTask = require('../../dao/scheduled_task');
var util = require('util');

/**
 * 添加
 */
var Add = function() { 
  Service.call(this);
};

util.inherits(Add, Service);

module.exports = Add;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
Add.prototype.process =  function(req, res) {
  if(!req.name) {
    this.onLogicError(1, '请提供任务名称！');
    return;
  }
  if(!req.type) {
    this.onLogicError(2, '请提供任务类型！');
    return;
  }
  if(!req.taskService) {
    this.onLogicError(3, '请提供服务路径！');
    return;
  }
  if(!req.exeTime) {
    this.onLogicError(4, '请提供执行时间！');
    return;
  }
  if(req.type==1 || req.type=='1') {
    if(!req.periodType) {
      this.onLogicError(4, '请提供周期类型！');
      return;
    }
    if(req.periodType!='day' && !req.periodRange) {
      this.onLogicError(5, '请提供周期间隔！');
      return;
    }
    if(!req.startDate) {
      this.onLogicError(5, '请提供开始时间！');
      return;
    }
    req.startDate = utils.strToDate(req.startDate + ':00');
    if(req.endDate) {
      req.endDate = utils.strToDate(req.endDate + ':00');
      if(req.startDate>req.endDate) {
        this.onLogicError(6, '开始时间不能晚于结束时间！');
        return;
      }
    }
  }
  
  var self = this;
  var dao = new ScheduledTask(this);
  dao.query({where: '(name=? or service=?) and org_id='+req.session.orgId,
    params:[req.name, req.taskService]}, 
    function(rows) {
    if(rows.length>0) {
      self.onLogicError(7, '任务已存在！');
      return;
    }
    var task = {};
    task.org_id = req.session.orgId;
    task.name = req.name;
    task.type = parseInt(req.type);
    task.service = req.taskService;
    task.status = 0;
    task.creater_id = req.session.userId;
    task.createtime = new Date();
    task.server_id = server.id;
    task.sys_task = 0;
    if(req.exeTime) task.exe_time = req.exeTime + ':00';
    if(task.type==1) {
      if(req.periodType) task.period_type = req.periodType;
      if(req.periodRange) task.period_range = req.periodRange;
      if(req.startDate) task.start_date = req.startDate;
      if(req.endDate) task.end_date = req.endDate;
    }

    dao.create(task, function(ret) {
      task.id = ret.insertId;
      global.server.scheduleTaskManager.tasks[task.id] = task;
      self.end(res);
    });
  });
};