var Service = require('Service');
var util = require('util');
var RoleDao = require('../../dao/role');
var AttachDao = require('../../dao/app_attach');

/**
 * 获得角色信息
 */
var Get = function() { 
  Service.call(this);
  this.enableTransaction = false;
};

util.inherits(Get, Service);

module.exports = Get;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
Get.prototype.process =  function(req, res) {
  if(!req.id) {
    this.onLogicError(1, '请提供角色编号！');
    return;
  }
  if(!req.fileCode) {
    this.onLogicError(2, '请提供图标文件编码！');
    return;
  }
  var self = this;
  var roleDao = new RoleDao(this);
  var attachDao = new AttachDao(this);
  attachDao.query({fields: 'id', where:'code=\''+req.fileCode
    +'\' and org_id='+req.session.orgId}, function(rows){
  	if(rows.length==0) {
  	  self.onLogicError(3, '图标文件不存在！');
      return;
  	}
    roleDao.update({head_id: rows[0].id}, {where: 'org_id='
      +req.session.orgId+' and id='+req.id}, function(rows) {
      self.end(res);
    });
  });
};