var Service = require('Service');
var util = require('util');
var utils = require('utils');
var RoleDao = require('../../dao/vrole_user');

/**
 * 获得角色用户列表
 */
var GetUserList = function() { 
  Service.call(this);
  this.enableTransaction = false;
};

util.inherits(GetUserList, Service);

module.exports = GetUserList;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetUserList.prototype.process =  function(req, res) {
  if(!req.id) {
    this.onLogicError(1, '请提供角色编号！');
    return;
  }
  if(!utils.isInt(req.id)) {
    this.onLogicError(2, '请提供正确的角色编号！');
    return;
  }
  var self = this;
  var roleDao = new RoleDao(this);
  var where = ' and user_status=0';
  var params = null;
  if(req.keyword){
    where = ' and (user_name like ?)';
    params = ['%'+req.keyword+'%'];
  }
  roleDao.queryDataPage(req, {
    fields:'* ,(select loginname from sys_user where id = vsys_role_user.user_id) as loginname', 
    where:'role_id='+req.id+' and org_id='+req.session.orgId +where,
    params: params,
    order: 'role_id'
  }, function(dataPage){
  	res.dataPage = dataPage;
    self.emit('end', res);
  });
};