var Service = require('Service');
var utils = require('utils');
var RoleType = require('../../dao/role_type');
var util = require('util');

/**
 * 获得用户职务列表
 */
var GetTypeList = function() { 
  Service.call(this);
};

util.inherits(GetTypeList, Service);

module.exports = GetTypeList;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetTypeList.prototype.process =  function(req, res) {
  var self = this;
  var roleType = new RoleType(this);
  roleType.query({field: 'id,name,code', 
    where: 'org_id='+req.session.orgId,
    order: 'code asc'}, function(rows) {
    res.data = rows;
    for(var i=0;i<res.data.length;i++) {
    	res.data[i].parent_id = 0;
    }
    self.end(res);
  });
};