var Service = require('Service');
var util = require('util');
var utils = require('utils');
var Dao = require('../../dao/role_type');

/**
 * 获得角色类型信息
 */
var GetType = function() { 
  Service.call(this);
};

util.inherits(GetType, Service);

module.exports = GetType;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetType.prototype.process =  function(req, res) {
  if(!req.id) {
    this.onLogicError(1, '请提供编号！');
    return;
  }
  if(!utils.isInt(req.id)) {
    this.onLogicError(2, '请提供正确的编号！');
    return;
  }
  var self = this;
  var dao = new Dao(this);
  dao.query({where:'id='+req.id+' and org_id='+req.session.orgId}, function(rows){
  	if(rows.length==0) {
  	  self.onLogicError(2, '编号不正确！');
      return;
  	}
    res.data = rows[0];
    self.emit('end', res);
  });
};