var Service = require('Service');
var utils = require('utils');
var MsgDao = require('../../dao/vmsg');
var util = require('util');

/**
 * 获得进群申请列表
 */
var GetRoleApplyList = function() { 
  Service.call(this);
  this.checkAuthority = false;
};

util.inherits(GetRoleApplyList, Service);

module.exports = GetRoleApplyList;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetRoleApplyList.prototype.process =  function(req, res) {
  var self = this;
  var dao = new MsgDao(this);
  dao.execute('select a.id,a.sender_id,d.name as sender_name,'
    +'IFNULL((SELECT id FROM sys_app_attach WHERE org_id=d.org_id '
    +'AND app_code=\'sys.userHead\' AND uploader_id=d.id ORDER BY id DESC LIMIT 1),0) AS head_id,'
    +'d.sex as sender_sex,a.send_time,a.content from sys_msg a,'
    +'sys_msg_app b,sys_msg_receive c,sys_user d where a.id=b.id '
    +'and a.id=c.id and a.org_id=d.org_id and a.sender_id=d.id and '
    +'b.app_code=\'sys\' and b.app_data_type=\'role/applyJoin\' and c.receiver_id='
    +req.session.userId+' and a.org_id='+req.session.orgId, null, function(rows) {
    res.rows = rows;
    for(var i=0;i<res.rows.length;i++) {
      res.rows[i].send_time = utils.formatDate(res.rows[i].send_time, 'yyyy-MM-dd hh:mm:ss');
    }
    self.end(res);
  });
};