var Service = require('Service');
var util = require('util');
var RoleDao = require('../../dao/role');

/**
 * 获得角色列表
 */
var GetList = function() { 
  Service.call(this);
  this.enableTransaction = false;
};

util.inherits(GetList, Service);

module.exports = GetList;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetList.prototype.process =  function(req, res) {
  var self = this;
  var roleDao = new RoleDao(this);
  var where = '';
  var params = [];
  if(req.name){
    where = ' and name=?';
    params.push(req.name);
  }
  if(req.typeName){
    where = ' and type=?';
    params.push(req.typeName);
  }
  roleDao.query({fields:'id,code,name,description,type',
    where:'status=0 and org_id='+req.session.orgId+where,
    params: params}, function(rows){
  	res.roles = rows;
    for(var i=0;i<res.roles.length;i++) {
      res.roles[i].parent_id = 0;
    }
    self.emit('end', res);
  });
};