var Service = require('Service');
var util = require('util');
var utils = require('utils');
var RoleDao = require('../../dao/role');
var RoleType = require('../../dao/role_type');

/**
 * 获得角色信息
 */
var Get = function() { 
  Service.call(this);
  this.enableTransaction = false;
};

util.inherits(Get, Service);

module.exports = Get;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
Get.prototype.process =  function(req, res) {
  if(!req.id) {
    this.onLogicError(1, '请提供角色编号！');
    return;
  }
  if(!utils.isInt(req.id)) {
    this.onLogicError(2, '请提供正确的角色编号！');
    return;
  }
  var self = this;
  var roleDao = new RoleDao(this);
  roleDao.query({where:'status=0 and id='+req.id+' and org_id='+req.session.orgId}, function(rows){
  	if(rows.length==0) {
  	  self.onLogicError(2, '角色编号不正确！');
      return;
  	}
    res.role = rows[0];
    var roleType = new RoleType(self);
    roleType.query({field: 'id,name,code', 
      where: 'org_id='+req.session.orgId,
      order: 'code asc'}, function(rows2) {
      res.types = rows2;
      self.end(res);
    });
  });
};