var Service = require('Service');
var utils = require('utils');
var Role = require('../../dao/role');
var util = require('util');

/**
 * 查找群组
 */
var Find = function() { 
  Service.call(this);
};

util.inherits(Find, Service);

module.exports = Find;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
Find.prototype.process =  function(req, res) {
  var where =' and allow_apply_join=1';
  /*
  if(!req.name) {
    this.onLogicError(1, '请提供群组名称！');
    return;
  }
  if(utils.haveEspecialChar(req.name)) {
    this.onLogicError(2, '群组名称中不能包含特殊字符！');
    return;
  }
  if(req.name.length>20) {
    this.onLogicError(3, '群组名称长度超出限制！');
    return;
  }
  */
  var params = null;
  if(req.name){
    if(utils.haveEspecialChar(req.name)) {
      this.onLogicError(2, '群组名称中不能包含特殊字符！');
      return;
    }
    if(req.name.length>20) {
      this.onLogicError(3, '群组名称长度超出限制！');
      return;
    }
    where += ' and name like ?';
    params = ['%'+req.name+'%'];
  }
  var self = this;
  var dao = new Role(this);
  dao.query({where:'org_id='+req.session.orgId+where, params: params}, function(rows) {
    res.roles = rows;
    self.emit('end', res);
  });
};