var Service = require('Service');
var utils = require('utils');
var Role_User = require('../../dao/role_user');
var Org = require('../../dao/org');
var util = require('util');

/**
 * 删除用户
 */
var DeleteUser = function() { 
  Service.call(this);
};

util.inherits(DeleteUser, Service);

module.exports = DeleteUser;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
DeleteUser.prototype.process =  function(req, res, cb) {
  if(!req.roleId) {
    this.onLogicError(1, '请提供角色编号！');
    return;
  }
  if(!utils.isInt(req.roleId)) {
    this.onLogicError(2, '请提供正确的角色编号！');
    return;
  }
  if(!req.user_id) {
    this.onLogicError(3, '请提供用户编号！');
    return;
  }
  var userIds = utils.strToIntArray(req.user_id);
  if(userIds.length==0) {
    this.onLogicError(4, '请提供用户编号！');
    return;
  }
  userIds = userIds.join();
  
  var self = this;
  var dao = new Role_User(this);
  dao.delete('role_id='+req.roleId+' and user_id in ('+userIds
    +') and org_id='+req.session.orgId, function() {
    var orgDao = new Org(self);
    orgDao.setLastUpdate(req.session.orgId, function(lastUpdate) {
      req.session.cache.rdel('role_user', {role_id:req.roleId, 
        user_id: userIds}, function(err) {
        if(err) {
          self.onError(err);
          return;
        }
        if(cb) {
          cb(req, res);
        } else {
          self.end(res);
        }
      });
    });
  });
};