var Service = require('Service');
var utils = require('utils');
var RoleDao = require('../../dao/role');
var RoleTypeDao = require('../../dao/role_type');
var util = require('util');

/**
 * 修改类型
 */
var UpdateType = function() { 
  Service.call(this);
};

util.inherits(UpdateType, Service);

module.exports = UpdateType;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
UpdateType.prototype.process =  function(req, res, cb) {
  if(!req.id) {
    this.onLogicError(1, '请提供编号！');
    return;
  }
  if(!utils.isInt(req.id)) {
    this.onLogicError(2, '请提供正确的编号！');
    return;
  }
  
  var self = this;
  var daoRole = new RoleDao(this);
  var daoRoleType = new RoleTypeDao(this);
  daoRole.query({ 
    where: 'org_id='+req.session.orgId+' and type=(select name from '
      +'sys_role_type where org_id='+req.session.orgId+' and id='+req.id+')',
    fields: 'id'
  }, function(rows) {
    if(rows.length>0) {
      self.onLogicError(3, '有系统群组信息使用了该类型，目前不能删除！');
      return;
    }
    daoRoleType.delete('org_id='+req.session.orgId+' and id='+req.id, function() {
      self.end(res);
    });
  });
};