var Service = require('Service');
var utils = require('utils');
var Role = require('../../dao/role');
var Org = require('../../dao/org');
var util = require('util');

/**
 * 删除角色信息
 */
var Delete = function() { 
  Service.call(this);
};

util.inherits(Delete, Service);

module.exports = Delete;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
Delete.prototype.process =  function(req, res) {
  if(!req.id) {
    this.onLogicError(1, '请提供角色编号！');
    return;
  }
  if(!utils.isInt(req.id)) {
    this.onLogicError(2, '请提供正确的角色编号！');
    return;
  }
  
  var self = this;
  var dao = new Role(this);
  dao.query({where: 'id='+req.id+' and org_id='+req.session.orgId}, function(rows) {
    if(rows.length==0) {
      self.onLogicError(2, '请提供角色编号！');
      return;
    }
    if(rows[0].name=='系统管理员' || rows[0].name=='所有人') {
      self.onLogicError(3, '该角色不允许删除！');
      return;
    }
    dao.delete('id='+req.id+' and org_id='+req.session.orgId, function() {
      var orgDao = new Org(self);
      orgDao.setLastUpdate(req.session.orgId, function(lastUpdate) { 
        req.session.cache.del('role', req.id, function(err) {
          if(err) {
            self.onError(err);
            return;
          }
          self.end(res);
        });
      });
    });
  });
};