var Service = require('Service');
var utils = require('utils');
var RoleUser = require('../../dao/role_user');
var Org = require('../../dao/org');
var util = require('util');

/**
 * 同意加入
 */
var AgreeJoin = function() { 
  Service.call(this);
  this.checkAuthority = false;
};

util.inherits(AgreeJoin, Service);

module.exports = AgreeJoin;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
AgreeJoin.prototype.process =  function(req, res) {
  if(!req.roleId) {
    this.onLogicError(1, '请提供群组编号！');
    return;
  }

  var role = req.session.org.roles[req.roleId];
  if(!role) {
    this.onLogicError(2, '群组不存在！');
    return;
  }

  if(!req.userId) {
    this.onLogicError(3, '请提供用户编号！');
    return;
  }

  var user = req.session.org.users[req.userId];
  if(!user) {
    this.onLogicError(4, '用户不存在！');
    return;
  }

  var self = this;
  var dao = new RoleUser(this);
  dao.query({where: 'org_id='+req.session.orgId+' and user_id='
    +req.userId+' and role_id='+req.roleId}, function(rows) {
    if(rows.length>0) {
      self.onLogicError(5, '该用户已是群成员！');
      return;
    }
    var roleUser = {};
    roleUser.org_id = req.session.orgId;
    roleUser.user_id = req.userId;
    roleUser.role_id = req.roleId;
    roleUser.creater_id = req.session.userId;
    roleUser.createtime = new Date();
    roleUser.is_admin = 0;
    dao.create(roleUser, function() {
      var orgDao = new Org(self);
      orgDao.setLastUpdate(req.session.orgId, function(lastUpdate) { 
        self.requestIMService('sys/service/cache/joinRoleUser', 
          {roleId:req.roleId, userId:req.userId}, req, function(resIM) {
          if(resIM.code!=0) {
            self.onError(resIM);
            return;
          }
          self.end(res);
        });
      });
    });
  });
};