var Service = require('Service');
var util = require('util');
var utils = require('utils');
var Dao = require('Dao');
var Role_User = require('../../dao/role_user');

/**
 * AddRole
 * 添加sys_role_user
 */
var AddRole = function() { 
  Service.call(this);
  this._dao = new Dao(this);
};

util.inherits(AddRole, Service);

module.exports = AddRole;

/**
 * 处理服务请求
 * @param  {object} req 服务请求对象
 * @param  {object} res 服务响应对象
 */
AddRole.prototype.process =  function(req , res) {
  //请求参数校验
  if(utils.isNull(req.org_id)) req.org_id = 1;
  if(!utils.isNull(req.org_id) && !utils.isInt(req.org_id)) {
    this.onLogicError(1, '参数[org_id]格式不正确！');
    return;
  }

  var self = this;
  self.num = 0;
  self.select_con(req,res);
  
};

AddRole.prototype.select_con =  function(req , res) {
  var self = this;
  self._dao.execute(
      "select role_id,user_id,(select name from sys_role where sys_role.id = sys_role_user.role_id) as role_name from sys_role_user where role_id in ("+req.role_id.join()+") and user_id="+req.user_id,null,
      function(data){
        if(data.length > 0){
          var names = ""
          for(var i = 0;i < data.length;i++){
            if(names!="") names += ",";
            names += data[i].role_name;
            if(i >= data.length - 1){
              self.onLogicError(''+names+'群组已经存在！');
         	 return;
            }
          }
         }else{
           self.add_con(req,res);
         }
    });
}

AddRole.prototype.add_con =  function(req , res) {
  var self = this;
  if(self.num >= req.role_id.length){
    self.end(res);
  }else{   
          let obj = {};
    	  if(!utils.isNull(req.org_id)) obj['org_id'] = parseInt(req.org_id);
          if(!utils.isNull(req.role_id)) obj['role_id'] = parseInt(req.role_id[self.num]);
          if(!utils.isNull(req.user_id)) obj['user_id'] = parseInt(req.user_id);
          if(!utils.isNull(req.session.userId)) obj['creater_id'] = parseInt(req.session.userId);
          obj['createtime'] = new Date();
          self._dao.model = server.loadModule('/app/sys/model/sys_role_user.tdm');
          self._dao.create(obj, function(ret) {
          self.num++;
          self.add_con(req,res);
   	});
  };
}
