var Service = require('Service');
var utils = require('utils');
var Org = require('../../dao/org');
var util = require('util');

/**
 * 修改单位默认密码
 */
var UpdateDefaultPwd = function() { 
  Service.call(this);
};

util.inherits(UpdateDefaultPwd, Service);

module.exports = UpdateDefaultPwd;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
UpdateDefaultPwd.prototype.process =  function(req, res) {
  if(!req.defaultPwd) {
    this.onLogicError(1, '请提供默认密码！');
    return;
  }
  
  var self = this;
  var dao = new Org(this); 
  dao.update({default_pwd: req.defaultPwd}, 
    {where: 'id='+req.session.orgId}, function(ret) {
    req.session.cache.setCurOrg({default_pwd: req.defaultPwd}, function(){
      self.end(res);
    });
  });
};