var Service = require('Service');
var utils = require('utils');
var Org = require('../../dao/org');
var util = require('util');

/**
 * 修改角色信息
 */
var Update = function() { 
  Service.call(this);
};

util.inherits(Update, Service);

module.exports = Update;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
Update.prototype.process =  function(req, res) {
  if(!req.default_pwd) {
    this.onLogicError(1, '请提供默认密码！');
    return;
  }

  var org = {
    default_pwd: req.default_pwd,
    create_group: req.create_group, 
    look_all: req.look_all, 
    look_self_bureau: req.look_self_bureau, 
    look_self_dep: req.look_self_dep, 
    look_leader: req.look_leader, 
    look_under: req.look_under, 
    user_cell_left_info: req.user_cell_left_info, 
    user_cell_right_info: req.user_cell_right_info,
    user_cell_bottom_info: req.user_cell_bottom_info, 
    show_type_in_role_list: req.show_type_in_role_list, 
    show_description_in_role_list: req.show_description_in_role_list, 
    show_app_center_banner: req.show_app_center_banner, 
    app_center_banner_height: 400, 
    client_view_title_bgcolor: req.client_view_title_bgcolor, 
    bind_device: req.bind_device, 
    client_button_bgcolor: req.client_button_bgcolor,
    last_update: new Date()
  };
  
  var self = this;
  var dao = new Org(this); 
  dao.update(org, {where: 'id='+req.session.orgId}, function(ret) {
    req.session.cache.setCurOrg(org, function(){
      self.end(res);
    });
  });
};