var Service = require('Service');
var util = require('util');
var utils = require('utils');
var Dao = require('Dao');

/**
 * Register
 */
var Register = function() { 
  Service.call(this);
};

util.inherits(Register, Service);

module.exports = Register;

/**
 * 处理服务请求
 * @param  {object} req 服务请求对象
 * @param  {object} res 服务响应对象
 */
Register.prototype.process =  function(req , res) {
  //请求参数校验
  if(utils.isNull(req.code)) {
    this.onLogicError(1, '请提供组织代码！');
    return;
  }
  req.code = req.code.toLowerCase();
  if(utils.isNull(req.name)) {
    this.onLogicError(2, '请提供组织名称！');
    return;
  }
  if(utils.isNull(req.userName)) {
    this.onLogicError(3, '请提供管理员昵称！');
    return;
  }
  if(utils.isNull(req.password)) {
    this.onLogicError(4, '请提供登录密码！');
    return;
  }
  if(utils.isNull(req.phone)) {
    this.onLogicError(5, '请提供手机号！');
    return;
  }
  if(utils.isNull(req.verifyCode)) {
    this.onLogicError(6, '请提供验证码！');
    return;
  }

  var self = this;
  self.sendHttpRequest({
    "urlPath": "http://om.taskmsg.com/Service",
    "method": "post",
    "headers": {
      "Content-Type": "application/x-www-form-urlencoded"
    },
    "postdata": {
      "service": "om/service/organize/registOrg",
      "orgCode": req.code,
      "orgName": req.name,
      "userName": req.userName,
      "phone": req.phone,
      "password": req.password,
      "verifyCode": req.verifyCode
    }
  },
  function(reqHttp, resHttp, errHttp, retHttp) {
    if(errHttp) {
        self.onLogicError(6, '注册失败，错误描述：'+errHttp.message);
        return;
    }
    if(!retHttp || (retHttp+"").indexOf("{")!=0) {
        self.onLogicError(1, '设置外网设置信息失败，平台返回信息格式有误！');
        return;
    }
    let ret = JSON.parse(retHttp);
    if(ret.code!=0) {
      self.onLogicError(ret.code, '注册失败，错误描述：'+ret.message);
      return;
    }
    let now = (new Date()).format("yyyy-MM-dd hh:mm:ss");
    self._dao = new Dao(self);
    self._dao.execute('update sys_org set code=?,name=?,auth_key=?,status=0,createtime=?,last_update=? where id=1', 
        [req.code, req.name, ret.authKey, now, now], function() {
        server.config.OrgCode = req.code;
        server.config.MessagePush = {
          PushServer: {
            host: "push.taskmsg.com",
            port: 7103,
            loginCode: req.code,
            loginKey: ret.authKey
          },
          msgIdFilePath: "/cache/msgId.json",
          enableAndPush: true
        };

        utils.saveJSONToFile(utils.getPath('/config/Tasgine.json'), server.config);
        self.end(res);
    });
  });
};
