var Service = require('Service');
var util = require('util');
var utils = require('utils');

/**
 * GetVCode
 */
var GetVCode = function() { 
  Service.call(this);
};

util.inherits(GetVCode, Service);

module.exports = GetVCode;

/**
 * 处理服务请求
 * @param  {object} req 服务请求对象
 * @param  {object} res 服务响应对象
 */
GetVCode.prototype.process =  function(req , res) {
  var self = this;
  self.sendHttpRequest({
    "urlPath": "http://om.taskmsg.com/Service",
    "method": "post",
    "headers": {
      "Content-Type": "application/x-www-form-urlencoded"
    },
    "postdata": {
        "service":"om/service/organize/sendVerifyCode",
        "data":req.data,
        "ts":req.ts
    }
  },
  function(reqHttp, resHttp, errHttp, retHttp) {
    if(errHttp) {
        self.onLogicError(1, '获取验证码失败，错误描述：'+errHttp.message);
        return;
    }
    let ret = JSON.parse(retHttp);
    if(ret.code!=0){
        self.onLogicError(ret.code, ret.message);
        return;
    }
    self.end(res);
  });
};
