var Service = require('Service');
var util = require('util');
var os = require('os');

/**
 * 重启子进程
 */
var RestartWorker = function() { 
  Service.call(this);
  this.checkLogin = false;
};

util.inherits(RestartWorker, Service);

module.exports = RestartWorker;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
RestartWorker.prototype.process =  function(req, res) { 
  if(!req.pid) {
    this.onLogicError(1, '请提供资源类型！');
    return;
  }
  this.end(res);
  //延时重启，以防关闭的是当前进程，无法返回响应信息
  setTimeout(function() {
    global.server.sendMsgToMaster({
      type: "restartWorker",
      workerId: req.pid
    });
  }, 500);
};
