var Service = require('Service');
var util = require('util');
var os = require('os');

/**
 * 获得服务器资源信息
 */
var GetResList = function() { 
  Service.call(this);
  this.checkLogin = false;
};

util.inherits(GetResList, Service);

module.exports = GetResList;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetResList.prototype.process =  function(req, res) { 
  if(!req.pid) {
    this.onLogicError(1, '请提供进程ID！');
    return;
  }
  var self = this;
  global.server.sendMsgToMaster({
    type: "getResList",
    desPid: parseInt(req.pid),
    cbFuncId: global.server.setCbFunc(function(ret) {
      res.net = ret.net;
      res.db = ret.db;
      res.fd = ret.fd;
      self.end(res);
    })
  });
};
