var util = require('util');
var utils = require('utils');
var crypto = require('crypto');
var Service = require('Service');
var Session = require('Session');

var Login = function () {
  Service.call(this);
  this.checkLogin = false;
  this.checkAuthority = false;
};

util.inherits(Login, Service);

module.exports = Login;

Login.prototype.process = function (req, res) {

  var orgCode = "";
  if (server.config.OrgCode) {
    orgCode = server.config.OrgCode;
  } else if (req.orgcode) {
    orgCode = req.orgcode;
  } else if (req.orgCode) {
    orgCode = req.orgCode;
  }

  if (orgCode == "") {
    this.onLogicError(1, '请提供组织代码！', req);
    return;
  }
  var reg = /^[a-zA-Z]([_a-zA-Z0-9]{3,20})$/;
  if (!reg.test(orgCode)) {
    this.onLogicError(1, '组织代码格式无效，只能包含字母、数字或下划线，且必须以字母开头！', req, res);
    return;
  }

  var self = this;
  server.cache.getOrgByCode(orgCode, function (org) {
    if (!org) {
      self.onLogicError(1, '请提供正确的组织代码！', req, res);
      return;
    }

    //账号登录
    if (req.accountcode) {
      if (!req.accountcode || req.accountcode == '') {
        self.onLogicError(3, '请提供账号代码！', req);
        return;
      }

      reg = /^([_a-zA-Z0-9\u4E00-\u9FA5\uFE30-\uFFA0]{2,20})$/;
      if (!reg.test(req.accountcode)) {
        self.onLogicError(3, '账号代码格式无效，只能是字母、数字、下划线或汉字！', req);
        return;
      }

      req.accountcode = req.accountcode.replace(/ /g, '').replace(/'/g, '').replace(/"/g, '');
      server.rediscache.getDataByIndex(org.id, "account", "accountcode", req.accountcode)
        .then(function (user) {
          if (!user) {
            self.onLogicError(3, '账号代码或密码不正确！', req);
          }
          else {
            self.checkLoginInfo(req, res, org, user);
          }
          return;
        })
        .catch(function (err) {
          self.onLogicError(3, '账号代码或密码不正确！', req);
          return;
        });
    }
    //手机号登录
    else if (req.mobile) {
      if (!utils.isPhone(req.mobile)) {
        self.onLogicError(2, '请提供正确的手机号！', req);
        return;
      }

      req.mobile = req.mobile.replace(/ /g, '').replace(/'/g, '').replace(/"/g, '');
      server.rediscache.getDataByIndex(org.id, "account", "mobile", req.mobile)
        .then(function (user) {
          if (!user) {
            self.onLogicError(3, '手机号或密码不正确！', req);
          }
          else {
            self.checkLoginInfo(req, res, org, user);
          }
          return;
        })
        .catch(function (err) {
          self.onLogicError(3, '手机号或密码不正确！', req);
          return;
        })
    }
    //用户名登录
    else {
      if (!req.loginname || req.loginname == '') {
        self.onLogicError(3, '请提供登录名！', req);
        return;
      }
      reg = /^([_a-zA-Z0-9\u4E00-\u9FA5\uFE30-\uFFA0]{2,20})$/;
      if (!reg.test(req.loginname)) {
        self.onLogicError(3, '登录名格式无效，只能是字母、数字、下划线或汉字！', req);
        return;
      }

      req.loginname = req.loginname.replace(/ /g, '').replace(/'/g, '').replace(/"/g, '');
      server.rediscache.getDataByIndex(org.id, "account", "loginname", req.loginname)
        .then(function (user) {
          if (!user) {
            self.onLogicError(3, '登录名或密码不正确！', req);
          }
          else {
            self.checkLoginInfo(req, res, org, user);
          }
          return;
        })
        .catch(function (err) {
          self.onLogicError(3, '登录名或密码不正确！', req);
          return;
        });
    }
  });
};



Login.prototype.checkLoginInfo = function (req, res, org, user) {
  var self = this;
  var clientType = 'web';
  if (req.clientType) clientType = req.clientType.toLowerCase();
  res.loginname = req.loginname;
  if (req.otherdata && req.otherlogin) res.pwd = req.pwd;

  //如果禁用增强的身份验证机制，则采用传统的简单身份验证机制
  if (server.config.disableEnhancedAuth) {
    //TODO
    if (!req.password || req.password != user.password) {
      this.onLogicError(4, '请提供正确的登录密码！', req);
      return;
    }
    req.session = new Session();
    server.sessionManager.sessions[req.session.id] = req.session;
    server.sessionManager.setNewSession(req, org, user, clientType, function () {
      self.endWebLogin(req, res, org, user);
    });
    return;
  }

  server.sessionManager.checkLoginInfoAccess(req, org, user, clientType, function (code, ret) {
    
    if (code != 0) {
      self.onLogicError(4, ret);
      return;
    }

    server.sessionManager.createClientLoginRet(req, res, org, user, clientType, function () {
      if (clientType == 'web') {
        self.endWebLogin(req, res, org, user);
        return;
      }

      if (!req.session.clientVersion) {
        req.session.clientVersion = req.clientVersion;
      }
      if (!req.session.deviceToken) {
        req.session.deviceToken = req.deviceToken;
      }
      req.session.userHead = user.head_id;

      self.endService(req, res);
    });
  });
};



Login.prototype.endWebLogin = function (req, res, org, user) {
  res.userSex = user.sex;
  res.orgName = org.name;
  res.themePath = "/app/sys/console/index.tfp";
  res.sessionId = req.session.id;

  this.endService(req, res);
};

/**
 * 结束服务
 * @param  {[type]} req [description]
 * @param  {[type]} res [description]
 * @return {[type]}     [description]
 */
Login.prototype.endService = function (req, res) {
  if (req.jsonpCallback) {
    req.socket.send(req.jsonpCallback + "(" + JSON.stringify(res) + ");");
    this.end(null);
  } else {
    this.end(res);
  }
};