var util = require('util');
var utils = require('utils');
var Service = require('Service');
var Session = require('Session');

/**
 * 登录
 */
var Login = function () {
  Service.call(this);
  this.checkLogin = false;
  this.checkAuthority = false;
};

util.inherits(Login, Service);

module.exports = Login;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
Login.prototype.process = function (req, res) {
  var self = this;
  this.loginHandler = new this.LoginHandler();
  if (req.clientType == 'web' && server.config.TGCache) {
    this.processTG(req, res);
    return;
  }

  if (server.config.Cache.type && server.config.Cache.type == 'taskmsg') {
    this.pipe(require('../../system/service/login'), req, res);
    return;
  }

  var orgCode = "";
  if (server.config.OrgCode) {
    orgCode = server.config.OrgCode;
  } else if (req.orgcode) {
    orgCode = req.orgcode;
  } else if (req.orgCode) {
    orgCode = req.orgCode;
  }

  if (orgCode == "") {
    this.onLogicError(1, '请提供组织代码！', req);
    return;
  }
  var reg = /^[a-zA-Z]([_a-zA-Z0-9]{4,20})$/;
  if (!reg.test(orgCode)) {
    this.onLogicError(1, '组织代码格式无效，只能包含字母、数字或下划线，且必须以字母开头！', req, res);
    return;
  }

  var self = this;
  server.cache.getOrgByCode(orgCode, function (org) {
    if (!org) {
      self.onLogicError(1, '请提供正确的组织代码！', req);
      return;
    }

    //其他编码
    if (req.otherdata && req.otherlogin) {
      var othercode = self.getOtherdata(req);
      server.cache.getList(org.id, "user", { where: "#{othercode}=='" + othercode + "'" }, function (err, rows) {
        if (rows.length == 0) {
          self.onLogicError(2, '请提供正确的登录代码！', req);
          return;
        }
        var user = rows[0];
        if (req.loginname) req.loginname = user.loginname;
        if (req.mobile) req.mobile = user.mobile;
        req.pwd = user.password;
        req.ts = (new Date()).getTime();
        req.clientType = "web";
        var ivData = [];
        if (req.mobile) {
          ivData = [req.mobile, req.pwd, req.clientType, req.ts];
        } else {
          ivData = [req.loginname, req.pwd, req.clientType, req.ts];
        }
        var iv = utils.md5(JSON.stringify(ivData)).substr(0, 16);
        ivData.push(iv);
        var key = utils.md5(JSON.stringify(ivData));
        req.data = utils.encryptAES(JSON.stringify(ivData), key, iv);
        ivData = null;

        self.checkLoginInfo(req, res, org, user);
      });
    }

    //手机号登录
    if (req.mobile) {
      if (!utils.isPhone(req.mobile)) {
        self.onLogicError(2, '请提供正确的手机号！', req);
        return;
      }

      req.mobile = req.mobile.replace(/ /g, '').replace(/'/g, '').replace(/"/g, '');
      server.cache.getList(org.id, "user", { where: "#{mobile}=='" + req.mobile + "'" }, function (err, rows) {
        if (err) {
          self.onLogicError(2, '请提供正确的手机号！', req);
          return;
        }
        if (rows.length == 0) {
          self.onLogicError(2, '请提供正确的手机号！', req);
          return;
        }
        self.handleOtherdata(req, org.id, rows[0], function () {
          self.checkLoginInfo(req, res, org, rows[0]);
        });
      });
    }
    //用户名登录
    else {
      if (!req.loginname || req.loginname == '') {
        self.onLogicError(3, '请提供登录名！', req);
        return;
      }
      reg = /^([_a-zA-Z0-9\u4E00-\u9FA5\uFE30-\uFFA0]{2,20})$/;
      if (!reg.test(req.loginname)) {
        self.onLogicError(3, '登录名格式无效，只能是字母、数字、下划线或汉字！', req);
        return;
      }

      req.loginname = req.loginname.replace(/ /g, '').replace(/'/g, '').replace(/"/g, '');
      server.cache.getList(org.id, "user", { where: "#{loginname}=='" + req.loginname + "'" }, function (err, rows) {
        if (err) {
          self.onLogicError(3, '登录名不正确！', req);
          return;
        }
        if (rows.length == 0) {
          self.onLogicError(3, '登录名不正确！', req);
          return;
        }

        self.handleOtherdata(req, org.id, rows[0], function () {
          self.checkLoginInfo(req, res, org, rows[0]);
        });
      });
    }
  });
};

Login.prototype.processTG = function (req, res) {
  if (server.config.TGCache.type && server.config.TGCache.type == 'taskmsg') {
    this.pipe(require('../../system/service/login'), req, res);
    return;
  }

  var self = this;
  server.tgsessionManager.checkLogin(self, req, res, function (err, ret) {
    if (err) {
      self.onLogicError(4, err, req, res);
      return;
    }

    res.ts = ret.ts;
    res.data = ret.data;
    req.session = ret.session;
    self.endWebLogin(req, res, ret.org, ret.user);
    return;
  });
};

Login.prototype.getOtherdata = function (req) {
  var othercode = "";
  try {
    var keytmp = [req.keycode, "mini", req.dts];
    var iv = utils.md5(JSON.stringify(keytmp)).substr(0, 16);
    keytmp.push(iv);
    var key = utils.md5(JSON.stringify(keytmp));
    var otherInfo = utils.decryptAES(req.otherdata, key, iv);
    othercode = JSON.parse(otherInfo)[0];
  }
  catch (err) {
  }

  return othercode;
};

Login.prototype.handleOtherdata = function (req, org_id, user, cb) {
  if (req.otherdata) {
    user.othercode = this.getOtherdata(req);

    server.cache.set(org_id, 'user', user.id, user, true, function (err) {
      server.sqlHandler.addSqlInfo({
        sql: "update sys_user set othercode=? where id=?",
        params: [user.othercode, user.id]
      });

      cb();
    });
  }
  else {
    cb();
  }
}

Login.prototype.checkLoginInfo = function (req, res, org, user) {
  var self = this;
  this.loginHandler.beforeLogin(req, res, function () {
    var clientType = 'web';
    if (req.clientType) clientType = req.clientType.toLowerCase();
    res.loginname = req.loginname;
    if (req.otherdata && req.otherlogin) res.pwd = req.pwd;

    //如果禁用增强的身份验证机制，则采用传统的简单身份验证机制
    if (server.config.disableEnhancedAuth) {
      if (!req.password || req.password != user.password) {
        this.onLogicError(4, '请提供正确的登录密码！', req);
        return;
      }
      req.session = new Session();
      server.sessionManager.sessions[req.session.id] = req.session;
      server.sessionManager.setNewSession(req, org, user, clientType, function () {
        self.endWebLogin(req, res, org, user);
      });
      return;
    }

    server.sessionManager.checkLoginInfo(req, org, user, clientType, function (code, ret) {
      if (code != 0) {
        self.onLogicError(4, ret);
        return;
      }

      server.sessionManager.createClientLoginRet(req, res, org, user, clientType, function () {
        if (clientType == 'web') {
          self.endWebLogin(req, res, org, user);
          return;
        }

        if (!req.session.clientVersion) {
          req.session.clientVersion = req.clientVersion;
        }
        if (!req.session.deviceToken) {
          req.session.deviceToken = req.deviceToken;
        }
        req.session.userHead = user.head_id;

        //如果启用了消息推送服务，则客户端登录后，要向消息服务器同步会话信息
        if (server.mpClient) {
          server.mpClient.addClientInfo(req.session, function (res3) {
            if (res3.code != 0) {
              self.onLogicError(14, '向消息推送服务器添加会话信息失败，错误描述：' + res3.message, req);
              return;
            }
            self.setOrgRes(req, res, org, user);
          });
          return;
        }

        self.setOrgRes(req, res, org, user);
      });
    });
  });
};

Login.prototype.endWebLogin = function (req, res, org, user) {
  res.userSex = user.sex;
  res.orgName = org.name;
  res.themePath = "/app/sys/console/index.tfp";
  res.sessionId = req.session.id;
  /*var themeId = server.config.DefaultTheme;
  if (user.theme_id) themeId = user.theme_id;
  for (var i = 0; i < server.config.Themes.length; i++) {
      var theme = server.config.Themes[i];
      if (theme.id == themeId) {
          res.themePath = theme.path;
          break;
      }
  }
  if (res.themePath == "") {
      res.themePath = server.config.Themes[0].path;
  }*/
  this.endService(req, res);

};

/**
 * 设置组织响应信息
 * @param {[type]} req  [description]
 * @param {[type]} res  [description]
 * @param {[type]} org  [description]
 * @param {[type]} user [description]
 */
Login.prototype.setOrgRes = function (req, res, org, user) {
  res.org = {};
  res.org.id = org.id;
  res.org.name = org.name;
  res.org.code = org.code;

  if (!org.last_update) org.last_update = new Date();
  if (typeof (org.last_update) == "string") org.last_update = new Date(org.last_update);
  res.org.lastUpdateTime = utils.formatDate(new Date(), 'yyyy-MM-dd hh:mm:ss'); //utils.formatDate(org.last_update, 'yyyy-MM-dd hh:mm:ss');

  //if(!org.appsLastUpdate) org.appsLastUpdate = new Date();
  //if(typeof(org.appsLastUpdate) == 'string') org.appsLastUpdate = new Date(org.appsLastUpdate);
  //res.org.appsLastUpdate = utils.formatDate(org.appsLastUpdate, 'yyyy-MM-dd hh:mm:ss');

  if (org.disable_chat) res.org.disable_chat = org.disable_chat;
  if (org.disable_msg_center) res.org.disable_msg_center = org.disable_msg_center;
  if (org.disable_address_book) res.org.disable_address_book = org.disable_address_book;
  if (org.hide_about) res.org.hide_about = org.hide_about;
  if (org.only_app_center) res.org.only_app_center = org.only_app_center;
  if (org.disable_app_center) res.org.disable_app_center = org.disable_app_center;
  if (org.app_center_title) res.org.app_center_title = org.app_center_title;
  if (server.config.MobileHomeUrl) res.org.app_center_url = server.config.MobileHomeUrl;
  org.app_center_url = "/app/sys/mobile/home_taskmsg.html";
  if (org.app_center_url) res.org.app_center_url = org.app_center_url;
  if (org.disable_my) res.org.disable_my = org.disable_my;
  if (org.my_url) res.org.my_url = org.my_url;
  if (org.appcenter_netdisk) res.org.appcenter_netdisk = org.appcenter_netdisk;
  if (org.ignore_pc_online) res.org.ignore_pc_online = org.ignore_pc_online;
  if (org.allow_add_friend) res.org.allow_add_friend = org.allow_add_friend;
  if (org.logo_image) res.org.logo_image = org.logo_image;
  if (org.slogan_image) res.org.slogan_image = org.slogan_image;
  if (org.launch_image) res.org.launch_image = org.launch_image;
  if (org.show_nickname_in_user_list) res.org.show_nickname_in_user_list = org.show_nickname_in_user_list;
  if (org.show_netstatus_in_user_list) res.org.show_netstatus_in_user_list = org.show_netstatus_in_user_list;
  if (org.show_post_in_user_list) res.org.show_post_in_user_list = org.show_post_in_user_list;
  if (org.show_motto_in_user_list) res.org.show_motto_in_user_list = org.show_motto_in_user_list;
  if (org.show_type_in_role_list) res.org.show_type_in_role_list = org.show_type_in_role_list;
  if (org.show_description_in_role_list) res.org.show_description_in_role_list = org.show_description_in_role_list;
  if (org.client_view_title_bgcolor) res.org.client_view_title_bgcolor = org.client_view_title_bgcolor;
  if (org.client_button_bgcolor) res.org.client_button_bgcolor = org.client_button_bgcolor;
  if (org.online_play_addr) res.org.online_play_addr = org.online_play_addr;
  if (org.work_circle_title) res.org.work_circle_title = org.work_circle_title;
  if (org.msg_center_title) res.org.msg_center_title = org.msg_center_title;
  if (org.user_cell_left_info) res.org.user_cell_left_info = org.user_cell_left_info;
  if (org.user_cell_right_info) res.org.user_cell_right_info = org.user_cell_right_info;
  if (org.user_cell_bottom_info) res.org.user_cell_bottom_info = org.user_cell_bottom_info;
  if (org.show_app_center_banner == 1) res.org.show_app_center_banner = 1;
  if (org.app_center_banner_height && org.app_center_banner_height > 0)
    res.org.app_center_banner_height = org.app_center_banner_height;
  if (org.client_not_cache_org == 1) res.org.client_not_cache_org = 1;

  var self = this;
  req.session.cache.getList('role', {
    fields: 'disable_work_circle,disable_address_book,disable_app_center,' +
      'disable_taskmsg,only_app_center',
    where: ['#{id} in ${1}', user.roles]
  },
    function (err, roles) {
      var role_disable_work_circle = 0;
      var role_disable_address_book = 0;
      var role_disable_app_center = 0;
      var role_disable_taskmsg = 0;
      var role_only_app_center = 0;

      for (var i = 0; i < roles.length; i++) {
        var role = roles[i];
        if (role.disable_work_circle && parseInt(role.disable_work_circle) == 1)
          role_disable_work_circle = 1;
        if (role.disable_address_book && parseInt(role.disable_address_book) == 1)
          role_disable_address_book = 1;
        if (role.disable_app_center && parseInt(role.disable_app_center) == 1)
          role_disable_app_center = 1;
        if (role.disable_taskmsg && parseInt(role.disable_taskmsg) == 1)
          role_disable_taskmsg = 1;
        if (role.only_app_center && parseInt(role.only_app_center) == 1)
          role_only_app_center = 1;
      }

      if (org.only_app_center) res.org.only_app_center = org.only_app_center;
      else if (role_only_app_center) res.org.only_app_center = role_only_app_center;
      else if (user.only_app_center) res.org.only_app_center = user.only_app_center;

      if (org.disable_app_center) res.org.disable_app_center = org.disable_app_center;
      else if (role_disable_app_center) res.org.disable_app_center = role_disable_app_center;
      else if (user.disable_app_center) res.org.disable_app_center = user.disable_app_center;

      if (org.disable_work_circle) res.org.disable_work_circle = org.disable_work_circle;
      else if (role_disable_work_circle) res.org.disable_work_circle = role_disable_work_circle;
      else if (user.disable_work_circle) res.org.disable_work_circle = user.disable_work_circle;

      if (org.disable_address_book) res.org.disable_address_book = org.disable_address_book;
      else if (role_disable_address_book) res.org.disable_address_book = role_disable_address_book;
      else if (user.disable_address_book) res.org.disable_address_book = user.disable_address_book;

      if (org.disable_taskmsg) res.org.disable_taskmsg = org.disable_taskmsg;
      else if (role_disable_taskmsg) res.org.disable_taskmsg = role_disable_taskmsg;
      else if (user.disable_taskmsg) res.org.disable_taskmsg = user.disable_taskmsg;

      self.setUserRes(req, res, org, user);
    });
};

/**
 * 设置用户响应信息
 * @param {[type]} req  [description]
 * @param {[type]} res  [description]
 * @param {[type]} org  [description]
 * @param {[type]} user [description]
 */
Login.prototype.setUserRes = function (req, res, org, user) {
  res.user = {};
  var userAttrs = 'id,code,name,loginname,sex,head_id,mobile,email,motto,' +
    'create_group,look_all,look_self_bureau,look_self_dep,look_leader,' +
    'look_under,only_app_center,disable_address_book,disable_work_circle,' +
    'disable_app_center,disable_taskmsg,hintPCOnline,isMute,muteStartTime,muteEndTime';
  userAttrs = userAttrs.split(',');
  for (var i = 0; i < userAttrs.length; i++) {
    var attr = userAttrs[i];
    if (user[attr] || user[attr] == 0) res.user[attr] = user[attr];
  }
  res.user.look_all = 1;
  res.user.look_self_bureau = 1;
  res.user.look_self_dep = 1;
  res.user.look_leader = 1;
  res.user.look_under = 1;
  res.user.create_group = 1;
  res.user.disable_chpwd = 0;

  /*if (!user.look_all) res.user.look_all = 0;
  if (!user.look_self_bureau) res.user.look_self_bureau = 0;
  if (!user.look_self_dep) res.user.look_self_dep = 0;
  if (!user.look_leader) res.user.look_leader = 0;
  if (!user.look_under) res.user.look_under = 0;
  res.user.create_group = 1;
  if (org.create_group) res.user.create_group = org.create_group;
  res.user.disable_chpwd = 0;
  if (org.disable_chpwd) res.user.disable_chpwd = org.disable_chpwd;*/

  //获取用户群组
  res.user.groups = {};

  //获得用户勿扰群
  res.user.muteRoles = [];
  res.user.muteGroups = [];
  res.user.muteDeps = [];


  if (!user.muteRoles) user.muteRoles = [];
  if (!user.muteGroups) user.muteGroups = [];
  if (!user.muteDeps) user.muteDeps = [];
  for (var i = 0; i < user.muteRoles.length; i++) {
    res.user.muteRoles.push(user.muteRoles[i]);
  }
  for (var i = 0; i < user.muteGroups.length; i++) {
    res.user.muteGroups.push(user.muteGroups[i]);
  }
  for (var i = 0; i < user.muteDeps.length; i++) {
    res.user.muteDeps.push(user.muteDeps[i]);
  }

  res.curServerTime = utils.formatDate(new Date(), 'yyyy-MM-dd hh:mm:ss');
  res.enableAndPush = server.config.MessagePush.enableAndPush;

  //获得用户群组信息
  var self = this;

  //系统勿扰群
  req.session.cache.getList('role_mute', { where: "#{user_id}==" + user.id }, function (err, muteRoles) {
    if (err) {
      self.onLogicError(3, err.message, req);
      return;
    }
    for (var i = 0; i < muteRoles.length; i++) {
      res.user.muteRoles.push(muteRoles[i].role_id);
    }
    //部门勿扰群
    req.session.cache.getList('dep_mute', { where: "#{user_id}==" + user.id }, function (err, muteDeps) {
      if (err) {
        self.onLogicError(3, err.message, req);
        return;
      }
      for (var i = 0; i < muteDeps.length; i++) {
        res.user.muteDeps.push(muteDeps[i].dep_id);
      }
      //用户勿扰群
      req.session.cache.getList('group_mute', { where: "#{user_id}==" + user.id }, function (err, muteGroups) {
        if (err) {
          self.onLogicError(3, err.message, req);
          return;
        }
        for (var i = 0; i < muteGroups.length; i++) {
          res.user.muteGroups.push(muteGroups[i].group_id);
        }
        self.endService(req, res);
        //self.setLeaderAndUnder(req, res, org, user);
      });
    });
  });

  /*req.session.cache.getList('group', {
    where: ['#{id} in ${1}', user.groups]
  },
    function (err, groups) {
      res.user.groups = {};
      for (var i = 0; i < groups.length; i++) {
        var group = utils.clone(groups[i]);
        if (group) {
          group.membersCount = group.users.length;
          var ids = [];
          for (var j = 0; j < group.users.length; j++) {
            ids.push(group.users[j]);
            if (j >= 49) {
              break;
            }
          }
          group.users = ids;
          res.user.groups[group.id] = group;
        }
      }

      self.setLeaderAndUnder(req, res, org, user);
    });*/




  //this.setLeaderAndUnder(req, res, org, user);
};

/**
 * 设置上下级信息
 * @param  {[type]} req  [description]
 * @param  {[type]} res  [description]
 * @param  {[type]} org  [description]
 * @param  {[type]} user [description]
 * @return {[type]}      [description]
 */
Login.prototype.setLeaderAndUnder = function (req, res, org, user) {
  res.user.leader = [];
  res.user.under = [];
  if (org.allow_add_friend == 1 || user.look_all == 1) {
    this.getExtAppInfo(req, res, org, user);
  } else {
    var self = this;
    var options = {
      fields: "user_id",
      where: [
        "(function() {" +
        "  for(var i=0;i<#{subDeps}.length;i++) {" +
        "    if(${1}.contains(#{subDeps}[i])) return true;" +
        "  }" +
        "  return false;" +
        "})()", user.deps
      ]
    };
    req.session.cache.getList("user", options, function (err, leaders) {
      if (err) {
        self.onLogicError(1, err.message, req, res);
        return;
      }
      for (var i = 0; i < leaders.length; i++) {
        res.user.leader.push(leaders[0].user_id);
      }
      self.getExtAppInfo(req, res, org, user);
    });
  }
};

/**
 * 获得扩展应用的相关信息
 * @param  {[type]} req  [description]
 * @param  {[type]} res  [description]
 * @param  {[type]} user [description]
 * @return {[type]}      [description]
 */
Login.prototype.getExtAppInfo = function (req, res, org, user) {
  //获得未读和待办任信数量
  if (!user.newTaskMsgCount) user.newTaskMsgCount = 0;
  res.newTaskMsgCount = user.newTaskMsgCount;
  //第一次登录，发送欢迎消息
  // if(!user.lastLoginTime && req._serverId!='IMServer' && req.clientType!='web'){
  //   req.title = '欢迎消息';
  //   req.content = '欢迎您，'+user.name+'！\n现在您即可享受系统提供的丰富功能，'
  //     +'快回到主界面，点击底部“更多”标签去看看吧！';
  //   req.userId = user.id;
  //   self.pipe(require('../../om/service/dev/sendMsg'),req,res,function(){
  //     self.saveSession(req, res);
  //   });
  // } else {

  this.endService(req, res);
  //}
};

/**
 * 结束服务
 * @param  {[type]} req [description]
 * @param  {[type]} res [description]
 * @return {[type]}     [description]
 */
Login.prototype.endService = function (req, res) {
  var self = this;
  self.loginHandler.afterLogin(req, res, function () {
    if (req.jsonpCallback) {
      req.socket.send(req.jsonpCallback + "(" + JSON.stringify(res) + ");");
      self.end(null);
    } else {
      self.end(res);
    }
  });
};

/**
 * 登录扩展类
 * @param  {[type]} req [description]
 * @param  {[type]} res [description]
 * @return {[type]}     [description]
 */
Login.prototype.LoginHandler = (function () {
  const LoginHandler = server.config.LoginHandler ? server.loadModule(server.config.LoginHandler) : function () { };
  if (!LoginHandler.prototype.beforeLogin) LoginHandler.prototype.beforeLogin = function (req, res, cb) { cb && cb(); };
  if (!LoginHandler.prototype.afterLogin) LoginHandler.prototype.afterLogin = function (req, res, cb) { cb && cb(); };
  return LoginHandler;
})()