var Service = require('Service');
var util = require('util');
var SessionDao = require('../../dao/log_session');
var LogDao = require('../../dao/vlog_request');

/**
 * 获得日志列表
 */
var GetSession = function() { 
  Service.call(this);
};

util.inherits(GetSession, Service);

module.exports = GetSession;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetSession.prototype.process =  function(req, res) {
  if(!req.id) {
    this.onLogicError(1, '请提供服务编号！');
    return;
  }
  var where = 'org_id='+req.session.orgId;
  if(req.session_id) where += ' and session_id='+req.session_id;
  if(req.keyword) {
    where += ' and (type like \'%'+req.keyword+'%\' or ip like \'%'+req.keyword
    	+'%\' or error_message like \'%'+req.keyword+'%\')';
  }
  var self = this;
  var logDao = new LogDao(this);
  logDao.queryDataPage(req, {where:where, order: 'id desc'}, function(dataPage){
  	res.dataPage = dataPage;
    self.emit('end', res);
  });
};