var Service = require('Service');
var util = require('util');
var RequestDao = require('../../dao/log_request');
var SessionDao = require('../../dao/log_session');
var ServiceDao = require('../../dao/log_service');
var ErrorDao = require('../../dao/log_error');
var DbDao = require('../../dao/log_db');
var DebugDao = require('../../dao/log_debug');

/**
 * 获得日志列表
 */
var GetService = function() { 
  Service.call(this);
};

util.inherits(GetService, Service);

module.exports = GetService;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetService.prototype.process =  function(req, res) {
  if(!req.id) {
    this.onLogicError(1, '请提供服务编号！');
    return;
  }
  var self = this;
  var serviceDao = new ServiceDao(this);
  serviceDao.query({where:'id='+req.id}, function(rowsService){
  	if(rowsService.length==0) {
  	  self.onLogicError(2, '请提供正确的服务编号！');
      return;
  	}
  	res.service = rowsService[0];
  	var dbDao = new DbDao(self);
	dbDao.query({where:'request_id='+res.service.id}, function(rowsDb) {
	  res.dbLog = rowsDb;
	  var debugDao = new DebugDao(self);
	  debugDao.query({where:'request_id='+res.service.id}, function(rowsDebug) {
	    res.debugLog = rowsDebug;
	    var errorDao = new ErrorDao(self);
	    errorDao.query({where:'request_id='+res.service.id}, function(rowsError) {
	  	  res.errorLog = rowsError;
	  	  var reqDao = new RequestDao(self);
	  	  reqDao.query({where: 'id='+res.service.id}, function(rowsReq) {
	  	  	if(rowsReq.length>0) res.req = rowsReq[0];
		  	if(res.service.session_id) {
		      var sessionDao = new SessionDao(self);
		      sessionDao.query({where: 'id='+res.service.session_id}, function(rowsSession) {
		      	if(rowsSession.length>0) res.session = rowsSession[0];
		      	self.emit('end', res);
		      });
		  	} else {
		      self.emit('end', res);
		    }
	  	  });
	    });	
	  });
	});
  });
};