var util = require('util');
var Service = require('Service');
var utils = require('utils');
var DaoDebug = require('../../dao/log_debug');

var GetReqDetails = function() {
  Service.call(this);
};

util.inherits(GetReqDetails, Service);

module.exports = GetReqDetails;

GetReqDetails.prototype.process =  function(req, res) {
  if(!req.requestId){
    this.onLogicError(1, '请提供请求编号！');
    return;
  }
  if(!req.id){
    this.onLogicError(2, '请提供日志编号！');
    return;
  }
  var self = this;
  var dao = new DaoDebug(this);
  
  dao.query({fields: 'id,server_type,message,time,millisecond', 
    where: 'request_id='+req.requestId+' and  id+100>='+req.id+' and id-100<='+req.id,
    order: 'time asc,millisecond asc'}, function(rows) {
    res.rows = rows;
    self.end(res);
  });
};