var Service = require('Service');
var util = require('util');
var LogDao = require('../../dao/log_sql');

/**
 * 获得日志列表
 */
var GetListSql = function() { 
  Service.call(this);
};

util.inherits(GetListSql, Service);

module.exports = GetListSql;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetListSql.prototype.process =  function(req, res) {
  var where = '1=1';
  if(req.startTime) where += ' and start_time>=\''+req.startTime+' 0:00:00\'';
  if(req.endTime) where += ' and start_time<=\''+req.endTime+' 23:59:59\'';
  if(req.keyword) {
    where = 'sql_text like \'%'+req.keyword+'%\' or params like \'%'+req.keyword
      +'%\' or session_id like \'%'+req.keyword+'%\'';
  }
  var self = this;
  var logDao = new LogDao(this);
  logDao.queryDataPage(req, {fields:'id,req_id,session_id,start_time,'
    +'start_ms,end_time,end_ms,use_time,sql_text,err_code',
    where:where, order: 'id desc'}, function(dataPage){
  	res.dataPage = dataPage;
    self.emit('end', res);
  });
};