var Service = require('Service');
var util = require('util');
var LogDao = require('../../dao/vlog_session');

/**
 * 获得日志列表
 */
var GetListSession = function() { 
  Service.call(this);
};

util.inherits(GetListSession, Service);

module.exports = GetListSession;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetListSession.prototype.process =  function(req, res) {
  var where = 'org_id='+req.session.orgId;
  if(req.keyword) {
    where += ' and (code like \'%'+req.keyword+'%\' or login_name like \'%'+req.keyword
      +'%\' or ip like \'%'+req.keyword+'%\' or server_type like \'%'+req.keyword
      +'%\' or client_type like \'%'+req.keyword+'%\')';
  }
  var self = this;
  var logDao = new LogDao(this);
  logDao.queryDataPage(req, {where:where, order: 'id desc'}, function(dataPage){
  	res.dataPage = dataPage;
    self.emit('end', res);
  });
};