var Service = require('Service');
var util = require('util');
var utils = require('utils');
var LogDao = require('../../dao/log_error');

/**
 * 获得日志列表
 */
var GetListError = function() { 
  Service.call(this);
};

util.inherits(GetListError, Service);

module.exports = GetListError;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetListError.prototype.process =  function(req, res) {
  var where = '1=1';
  if(req.startTime) where += ' and `req_time`>=\''+req.startTime+' 0:00:00\'';
  if(req.endTime) where += ' and `req_time`<=\''+req.endTime+' 23:59:59\'';
  if(req.keyword) {
    where = '`type` like \'%'+req.keyword+'%\' or `message` like \'%'+req.keyword
      +'%\' or session_id like \'%'+req.keyword+'%\' or req_id like \'%'+req.keyword+'%\'';
  }
  var self = this;
  var logDao = new LogDao(this);
  logDao.queryDataPage(req, {fields:'id,req_id,session_id,type,message,req_time',
    where:where, order: 'id desc'}, function(dataPage){
    res.dataPage = dataPage;
    for(var i=0;i<res.dataPage.rows.length;i++) {
      let row = res.dataPage.rows[i];
      if(row.message && row.message.length>100) row.message = row.message.substr(0, 100);
    }
    self.emit('end', res);
  });
};