var Service = require('Service');
var util = require('util');
var LogDao = require('../../dao/vlog_download');

/**
 * 获得日志列表
 */
var GetListDownload = function() { 
  Service.call(this);
};

util.inherits(GetListDownload, Service);

module.exports = GetListDownload;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetListDownload.prototype.process =  function(req, res) {
  var where = '1=1';
  if(req.startTime) where += ' and req_time>=\''+req.startTime+' 0:00:00\'';
  if(req.endTime) where += ' and req_time<=\''+req.endTime+' 23:59:59\'';
  if(req.keyword) {
    where += ' and (ip like \'%'+req.keyword+'%\' or file_name like \'%'+req.keyword
      +'%\' or file_code like \'%'+req.keyword+'%\' or session_id like \'%'+req.keyword+'%\')';
  }
  var self = this;
  var logDao = new LogDao(this);
  logDao.queryDataPage(req, {where:where, order: 'id desc'}, function(dataPage){
  	res.dataPage = dataPage;
    self.emit('end', res);
  });
};