var Service = require('Service');
var util = require('util');
var utils = require('utils');
var LogDao = require('../../dao/log_debug');

/**
 * 获得日志列表
 */
var GetListDebug = function() { 
  Service.call(this);
};

util.inherits(GetListDebug, Service);

module.exports = GetListDebug;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetListDebug.prototype.process =  function(req, res) {
  var kssj = req.kssj?req.kssj:utils.formatDate(new Date(),'yyyy-MM-dd 00:00:00');
  var jssj = req.jssj?req.jssj:utils.formatDate(new Date(),'yyyy-MM-dd 23:59:59.999');
  var where = '`time`>=\''+kssj+'\' and `time`<=\''+jssj+'\'';
  if(req.keyword) {
    where += ' and `message` like \'%'+req.keyword+'%\'';
  }
  if(req.requestId) {
    where += ' and request_id='+req.requestId;
  }  
  if(req.server_type) {
    where += ' and server_type=\''+req.server_type+'\'';
  }

  var lenFuncName = "CHAR_LENGTH";
  if(server.config.Database.type=="mssql") lenFuncName = "DATALENGTH";

  var self = this;
  var logDao = new LogDao(this);
  logDao.queryDataPage(req, {fields:'id,request_id,session_id,server_type,'+
      '(CASE WHEN '+lenFuncName+'(message)>50 then concat(left(message, 50), "...") ELSE message END) as message,time,millisecond',
                             where:where, order: 'id desc'}, function(dataPage){
    res.dataPage = dataPage;
    self.emit('end', res);
  });
};