var util = require('util');
var Service = require('Service');
var utils = require('utils');
var Dao = require('../../dao/log_request');

var GetDetailRequest = function() {
  Service.call(this);
};

util.inherits(GetDetailRequest, Service);

module.exports = GetDetailRequest;

GetDetailRequest.prototype.process =  function(req, res) {
  if(!req.id){
    this.onLogicError(2, '请提供请求编号！');
    return;
  }
  var self = this;
  var dao = new Dao(this);
  dao.query({where: 'id='+req.id}, function(rows) {
    if(rows.length==0) {
      self.onLogicError(2, '请提供正确的请求编号！');
      return;
    }
    res.reqInfo = rows[0];
    self.end(res);
  });
};