var util = require('util');
var Service = require('Service');
var utils = require('utils');
var Dao = require('../../dao/log_error');

var GetDetailError = function() {
  Service.call(this);
};

util.inherits(GetDetailError, Service);

module.exports = GetDetailError;

GetDetailError.prototype.process =  function(req, res) {
  if(!req.id){
    this.onLogicError(2, '请提供日志编号！');
    return;
  }
  var self = this;
  var dao = new Dao(this);
  dao.query({where: 'id='+req.id}, function(rows) {
    if(rows.length==0) {
      self.onLogicError(2, '请提供正确的日志编号！');
      return;
    }
    res.data = rows[0];
    self.end(res);
  });
};