var util = require('util');
var Service = require('Service');
var utils = require('utils');
var DaoDebug = require('../../dao/log_debug');
var DaoError = require('../../dao/log_error');

var GetDetail = function() {
  Service.call(this);
};

util.inherits(GetDetail, Service);

module.exports = GetDetail;

GetDetail.prototype.process =  function(req, res) {
  var self = this;
  var dao;
  if(!req.logType){
    this.onLogicError(1, '请提供日志类型！');
    return;
  }
  if(!req.id){
    this.onLogicError(2, '请提供日志编号！');
    return;
  }
  if(req.logType=='error')
    dao = new DaoError(this);
  else if(req.logType=='debug')
    dao = new DaoDebug(this);
  else{
    this.onLogicError(1, '请提供正确的日志类型！');
    return;  
  }
  
  dao.query({fields: 'id,request_id,server_type,message,time,millisecond', 
    where: 'id='+req.id}, function(rows) {
    if(rows.length==0){
      this.onLogicError(3, '未找到相关日志！');
      return;
    }
    res.data = rows[0];
    res.data.message = res.data.message.replace(/\\n/g, '<br>').replace(/\s/g, '&nbsp;&nbsp;');
    self.end(res);
  });
};