var Service = require('Service');
var utils = require('utils');
var Dao = require('../../dao/log');
var util = require('util');

/**
 * 创建日志
 */
var Add = function() { 
  Service.call(this);
  this.checkLogin = false;
};

util.inherits(Add, Service);

module.exports = Add;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
Add.prototype.process =  function(req, res) {
  var log = {};
  log.time = new Date(); 
  log.ip = req.remoteAddress;
  log.port = req.remotePort;
  log.service = 'log/add';
  log.app = 'sys';
  log.client_version = req.clientVersion;
  log.device_info = req.deviceInfo;
  log.error_info = req.errorInfo;
  if(req._serverId) {
    log.server_type = req._serverId;
  } else {
    log.server_type = req.serverType;
  }
  if(req.session) {
    log.org_id = req.session.orgId; 
    log.user_id = req.session.userId; 
    log.user_name = req.session.user.name; 
    log.session_id = req.session.id;
    log.client_type = req.session.clientType;
    log.net_type = req.session.netType;
  } else {
    log.org_id = req.orgId; 
    log.user_id = req.userId; 
    log.user_name = req.userName; 
    log.session_id = req.sessionId;
    log.client_type = req.clientType;
    log.net_type = req.netType;
  }

  var self = this;
  var dao = new Dao(this);
  dao.create(log, function(ret) {
      self.emit('end', res);
  });
};