var Service = require('Service');
var util = require('util');
var os = require('os');
var Dao = require('Dao');

/**
 * 获得服务器统计信息
 */
var GetServerStat = function() { 
  Service.call(this);
  this.checkLogin = false;
  this._dao = new Dao(this);
};

util.inherits(GetServerStat, Service);

module.exports = GetServerStat;

/**
 * 获取 CPU 信息
 * @returns { Object } CPU 信息
 */
function getCPUInfo() {
  const cpus = os.cpus();
  let user = 0, nice = 0, sys = 0, idle = 0, irq = 0, total = 0;

  //console.log(cpus);
  for (var i=0;i<cpus.length;i++) {
    const times = cpus[i].times;
    user += times.user;
    nice += times.nice;
    sys += times.sys;
    idle += times.idle;
    irq += times.irq;
  }

  total += user + nice + sys + idle + irq;

  return {
    user,
    sys,
    idle,
    total,
  }
}

/**
 * 获取某时间段 CPU 利用率
 * @returns 
 */
function getCPUUsage(cb) {
  const t1 = getCPUInfo(); // t1 时间点 CPU 信息
  setTimeout(function() {  
    const t2 = getCPUInfo(); // t2 时间点 CPU 信息
    const idle = t2.idle - t1.idle;
    const total = t2.total - t1.total;
    let usage = 1 - idle / total;
    usage = (usage * 100.0).toFixed(2);
    cb(usage);
  }, 1000);
}

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetServerStat.prototype.process =  function(req, res) { 
  var self = this;
  if(server.workerType) {
    let msgSend = {
      type: "stat",
      cbFuncId: global.server.setCbFunc(function(stat) {
        self.onStat(req, res, stat);
      })
    };
    global.server.sendMsgToMaster(msgSend);
  } else {
    let stat = {
      startTime: server.startTime,
      procList: [],
      bgs: 0,
      session: 0
    };
    for(let sid in server.bgServices) {
      stat.bgs++;
    }
    for(let sid in server.sessionManager.sessions) {
      stat.session++;
    }
    for(let p in server.stat) {
      stat[p] = server.stat[p];
    }
    self.onStat(req, res, stat);
  }
};

GetServerStat.prototype.onStat =  function(req, res, stat) { 
  res.stat = stat;
      
  //要减除当前连接
  //res.stat.net.cur = stat.net.cur - 1;
  
  // 获取当前Node内存堆栈情况
  let memoryUsage = process.memoryUsage();
  // 获取系统空闲内存
  let sysFree = os.freemem();
  // 获取系统总内存
  let sysTotal = os.totalmem();

  res.stat.memUsage = ((1 - sysFree / sysTotal) * 100.0).toFixed(2);
  res.stat.heapUsage = ((1 - memoryUsage.heapUsed / memoryUsage.heapTotal) * 100.0).toFixed(2);
  res.stat.nodeUsage = ((memoryUsage.rss / sysTotal) * 100.0).toFixed(2);

  var self = this;
  getCPUUsage(function(usage) {
    res.stat.cpuUsage = usage;
    self.select_msg(req, res, stat);
  });
};

// 查询新消息
GetServerStat.prototype.select_msg =  function(req, res, stat) { 
  res.stat = stat;
      
  var self = this;
  self._dao.queryDataPageBySql(
    req, "select id as receive_id,type,sender_id as id,summary,send_time from vsys_msg_receive where receive_status_web = 0 and org_id = 1 and receiver_id = "+req.session.userId+" order by send_time desc,id desc ", null,
    function(rows) {
    res.stat.msg = rows;
    self.end(res);
  });
};