var url = require('url');
var fs = require('fs');
var path = require('path');
var BufferHelper = require('BufferHelper');
var querystring = require('querystring');
var utils = require('utils');

/**
 * HttpHandlerDemo
 */
var HttpHandlerDemo = function () {
    //
};

module.exports = HttpHandlerDemo;

HttpHandlerDemo.prototype.process = function (request, response) {
    //通过request获得请求数据
    console.log(request.socket.remoteAddress + ':' + request.socket.remotePort + '已连接到服务器！');
    console.log('请求路径：' + request.url);
    
    //解析请求参数
    var req = null;
    var bufferHelper = new BufferHelper();
    request.on('data', function (chunk) {
        bufferHelper.concat(chunk);
    });

    request.on('end', function () {
        var reqQuery = url.parse(request.url, true).query;
        reqString = bufferHelper.toBuffer().toString();
        bufferHelper = null;
        //解析xml
        var parseString = require('xml2js').parseString;
        parseString(reqString, function (err, result) {
            console.dir(result);

            //通过response返回响应数据
            let html = "<html><head><title>HttpHandlerDemo</title></head><body>OK</body></html>";
            response.setHeader('Content-Type', 'text/html');
            response.setHeader('Content-Length', Buffer.byteLength(html, "utf-8"));
            response.setHeader('Accept-Ranges', 'bytes');
            response.writeHead(200, 'Ok');
            response.write(html);
            response.end();
        });
    });
}