var url = require('url');
var fs = require('fs');
var path = require('path');
var utils = require('utils');
var formidable = server.loadModule('/node_modules/formidable/index.js'); //require('formidable');
var BufferHelper = require('BufferHelper');
var ServiceHandler = require('ServiceHandler');

/**
 * 服务处理器
 */
var UploadHandler = function () {
    this.uploadService = "sys/service/app/uploadAttachByHttp";
    if (server.config.Services && server.config.Services.UploadService) this.uploadService = server.config.Services.UploadService;
  };
  
  module.exports = UploadHandler;
  
  /**
   * 执行
   * @param {*} request 
   * @param {*} response 
   */
  UploadHandler.prototype.process = function (request, response) {
    let req = url.parse(request.url, true).query;

    var self = this;

    if(req.action=="config") {
        var filePath = utils.getPath('/web/inc/ueditor/config.json');
        if (!fs.existsSync(filePath)) {
            self.onLogicError(1, '文件不存在！');
            return;
        }
        fs.readFile(filePath, 'utf-8', function (err, data) {
            self.end(request, response, data);
        });
    } else if (req.action == "uploadimage" || req.action == "uploadfile" || req.action == "uploadvideo") {
        this.upload(request, response, req);
    }
  }

  UploadHandler.prototype.upload = function (request, response, req) {
    var self = this;
    var uploadDir = utils.getPath("/files/tmp/");
    var form = new formidable.IncomingForm({ "uploadDir": uploadDir });
    form.parse(request, function (error, fields, files) {
        if (error) {
            server.responseErrorByJSON(request, response, 400, '上传文件时发生意外错误：' + error.message);
            return;
        }

        let srcFileName = "";
        let fileType = "";
        let tmpFilePath = "";

        for (fileId in files) {
            var file = files[fileId];
            var fileCode = file.path.substr(file.path.indexOf('upload_') + 7);
            logger.log('上传文件：' + file.name + '，文件大小：' + file.size+'，文件代码：'+fileCode, request._id);

            srcFileName = file.name;
            fileType = file.name.substr(file.name.lastIndexOf("."));
            tmpFilePath = file.path;
        }

        let fileUrl = "";
        let savePath = utils.getPath("/web/upload/");
        if(req.action == "uploadimage") {
            savePath += "image/";
            fileUrl = "image/";
        } else if(req.action == "uploadfile") {
            savePath += "file/";
            fileUrl += "file/";
        } else if(req.action == "uploadvideo") {
            savePath += "video/";
            fileUrl += "video/";
        }
        if(!fs.existsSync(savePath)) fs.mkdirSync(savePath);
        let date = (new Date()).format("yyyyMMdd");
        savePath += date+"/";
        fileUrl += date+"/";
        if(!fs.existsSync(savePath)) fs.mkdirSync(savePath);
        var rand = '' + (parseInt(Math.random()*1000000)+1000000);
        rand = rand.substring(1, 7); 
        let saveFileName = (new Date()).format("hhmmss")+rand+fileType;
        savePath += saveFileName;
        fileUrl += saveFileName;

        let ret = {
            url: fileUrl,
            original: srcFileName,
            state: "SUCCESS",
            title: srcFileName 
        };

        fs.rename(tmpFilePath, savePath, function() {
            self.end(request, response, JSON.stringify(ret));
        });
    });
  };

  UploadHandler.prototype.end = function (request, response, msg) {
    response.writeHead(200, { "Content-Type": "text/html;charset=utf-8" }); //OK
    if(msg) response.write(msg);
    response.end();
  };