var url = require('url');
var fs = require('fs');
var path = require('path');
var querystring = require('querystring');
var utils = require('utils');
var markdown = require( "marked" );

/**
 * MarkDown文件处理器
 */
var MarkDownHandler = function () {
  //
};

module.exports = MarkDownHandler;

MarkDownHandler.prototype.process = function (request, response) {
  //解析物理路径
  var physicalPath = url.parse(request.url).pathname;
  //去掉路径中的“../”，防止恶意访问
  physicalPath = path.normalize(physicalPath.replace(/\.\./g, ''));
  physicalPath = path.join('/web', physicalPath);
  //解析实际URL路径
  request.physicalPath = utils.getPath('/' + physicalPath);

  var self = this;
  fs.stat(request.physicalPath, function (err, stats) {
    if (err || stats.isDirectory()) {
      global.server.responseErrorByHTML(request, response, 404, '请求地址无效。');
      return;
    }
    fs.readFile(request.physicalPath, "utf-8", function(err, data) {
      var lastModified = stats.mtime.toUTCString();
      var ifModifiedSince = 'If-Modified-Since'.toLowerCase();
      //如果客户端有缓存，则不解析
      if (request.headers[ifModifiedSince] && lastModified == request.headers[ifModifiedSince]) {
        //response.writeHead(304, 'Not Modified');
        //response.end();
        //return;
      }
      
      let html = "";
      try {
        html = markdown.parse(data);
        //html = html.replace(/<code class=\"language-javascript\">/g, "");
        //html = html.replace(/<\/code>/g, "");
        //html = html.replace(/<pre>/g, "<pre style=\"display:none;\">");
        //html = html.replace(/<\/pre>/g, "</pre>\r\n<div class=\"code-editor\"></div>");
        html = html.replace(/<table>/g, "<table border=\"1\" cellpadding=\"10\" cellspacing=\"0\" bordercolor=\"#333333\" style=\"border-collapse:collapse\">");
      } catch(err2) {
        console.log(err2);
        global.server.responseErrorByHTML(request, response, 500, '解析md文件失败。');
        return;
      }

      var head = "<html>\r\n"
        +"<head>\r\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\r\n"
        +"<meta name=\"keywords\" content=\"taskbuilder,TaskBuilder,任构,低代码,低代码开发,低代码开发工具,前端开发,快速开发工具,编程工具,软件开发,代码编辑器,IDE\" />\r\n"
        +"<meta name=\"description\" content=\"TaskBuilder是一款面向程序员的低代码开发工具，可以大幅提升软件开发效率。\" />\r\n"
        +"<title>"+path.basename(physicalPath)+"</title>\r\n"
        +"<style>\r\n"
        +"@font-face {\r\n"
        +"  font-family:'SourceCodePro';\r\n"
        +"  src: url('/inc/SourceCodePro-Regular.ttf');\r\n"
        +"}\r\n"
        +"code,code span {\r\n"
        +"  font-family:'SourceCodePro'; font-size:14px;\r\n"
        +"}\r\n"
        +"  body {background-color: #ffffff;}\r\n"
        +"  ::-webkit-scrollbar {width: 6px;height: 6px;}\r\n"
        +"  ::-webkit-scrollbar-thumb {-webkit-box-shadow: inset 0 0 5px rgba(0,0,0,0.2);background: #666666;border-radius: 2px;}\r\n"
        +"  ::-webkit-scrollbar-track {-webkit-box-shadow: inset 0 0 5px rgba(0,0,0,0.2);background: #444;}\r\n"
        +"  ::-webkit-scrollbar-corner {background: #444;}\r\n"
        +"  p,li {line-height: 180%;}\r\n"
        +"</style>\r\n";
      //if(html.indexOf("code-editor")>0) {
        head += "<script src=\"/inc/jquery-1.11.2.min.js\"></script>\r\n"
          +"<script src=\"/inc/markdowntoc.js\"></script>\r\n"
          //+"<script src=\"/inc/codemirror/lib/codemirror.js\"></script>\r\n"
          //+"<link rel=\"stylesheet\" href=\"/inc/codemirror/lib/codemirror.css\">\r\n"
          //+"<script src=\"/inc/codemirror/mode/javascript/javascript.js\"></script>\r\n"
          +"<link rel=\"stylesheet\" href=\"/inc/highlight/styles/default.min.css\">\r\n"
          +"<script src=\"/inc/highlight/highlight.min.js\"></script>\r\n"
          +"<script type=\"text/javascript\">\r\n"
          +"$(function() {\r\n"
          +"hljs.highlightAll();\r\n"
          +"$('code').each(function() {\r\n"
          +"  if($(this).attr('class')) return;\r\n"
          +"  $(this).css('color','#990000');\r\n"
          +"  $(this).css('background-color','#eeeeee');\r\n"
          +"  $(this).css('border','1px solid #cccccc');\r\n"
          +"  $(this).css('border-radius','4px');\r\n"
          +"  $(this).css('padding-left','5px');\r\n"
          +"  $(this).css('padding-right','5px');\r\n"
          +"});\r\n"
          +"createToc();\r\n"
          /*+"  $('.code-editor').each(function(){\r\n "
          +"    var curCode = $(this).prev().get(0).innerText;\r\n"
          +"    var curHeight = $(this).prev().height(); //console.log($(this).prev().height());\r\n"
          +"    var curCodeMirror = CodeMirror(this, {\r\n"
          +"      lineNumbers: true,\r\n"
          +"      styleActiveLine: true,\r\n"
          +"      matchBrackets: true,\r\n"
          +"      selectionPointer: true,\r\n"
          +"      foldGutter: true,\r\n"
          +"      readOnly: true,\r\n"
          +"      autoCloseBrackets: true,\r\n"
          +"      gutters: [\"CodeMirror-lint-markers\", \"CodeMirror-linenumbers\", \"CodeMirror-foldgutter\"],\r\n"
          +"      mode: 'javascript'\r\n"
          +"    });\r\n"
          +"    $(this).find(\".CodeMirror\").css(\"height\", (curHeight+(curHeight/30)*10+20)+\"px\");\r\n"
          +"    curCodeMirror.setValue(curCode);\r\n"
          +"  });\r\n"*/
          +"});\r\n"
          +"</script>\r\n"
      //}
      head += "</head>\r\n";
      html = head + "<body style=\"margin:40px;\"><div id='divTop' style=\"position:absolute; z-index:1; "
        +"top: 0; bottom:0; left:0; right:0;display:flex; justify-content: center;align-items: start; \">"
        +"<div style=\"width:800px; margin-left:20px; margin-right:20px; min-width:840px;\">\r\n"+html+"\r\</div></div></body>\r\n</html>";
      
      response.setHeader('Content-Type', 'text/html');
      response.setHeader('Content-Length', Buffer.byteLength(html, "utf-8"));
      response.setHeader('Accept-Ranges', 'bytes');
      response.setHeader('Last-Modified', lastModified);
      response.writeHead(200, 'Ok');
      response.write(html);
      response.end();
    });
  });
}