var Service = require('Service');
var util = require('util');

/**
 * 登录
 */
var GetSysData = function () {
  Service.call(this);
  this.checkLogin = false;
};

util.inherits(GetSysData, Service);

module.exports = GetSysData;

/**
 * 处理服务请求
 * @param {Object} req 服务请求对象
 * @param {Object} res 服务响应对象
 */
GetSysData.prototype.process = function (req, res) {
  if (server.config.Cache.type && server.config.Cache.type == 'taskmsg') {
    this.pipe(require('../../system/service/getSysData'), req, res);
    return;
  }
  var self = this;
  res.favicon = "/img/login/favicon.ico";
  res.sysname = "任擎后台管理系统";
  res.companyname = "北京任讯信息技术有限公司";
  res.copyright = "© TaskMsg Co.Ltd www.taskmsg.com 400-009-6678";
  res.orgcode = "taskmsg";
  res.loginlogo = "url(/images/login/login_logo.png)";
  res.logintelephone = "url(/images/login/login_telephone.png)";
  // res.loginbackgroundcolor = "#446FF5";
  // res.loginbackgroundimage = "url(/images/login/bgi0.png)";
  res.loginbackgrounds = [
    {"backgroundImage":"url(/images/login/bgi0.png)","backgroundColor":"#446FF5"},
    {"backgroundImage":"url(/images/login/bgi1.png)","backgroundColor":"#1B38AC"},
    {"backgroundImage":"url(/images/login/bgi2.png)","backgroundColor":"#1774D1"},
    {"backgroundImage":"url(/images/login/bgi3.png)","backgroundColor":"#E55B1C"}
  ];
  res.mainlogo = "url(/images/main/main_logo.png)";
  res.maininfo = "版权所有 北京任讯信息技术有限公司 2021-2023";
  self.end(res);
};