var Service = require('Service');
var util = require('util');
var qr_image = require("qr-image");

/**
 * 获取二维码
 */
var GetQrCode = function () {
    Service.call(this);
    this.checkLogin = false;
};

util.inherits(GetQrCode, Service);

module.exports = GetQrCode;

/**
 * 处理服务请求
 * @param {Object} req 服务请求对象
 * @param {Object} res 服务响应对象
 */
GetQrCode.prototype.process = function (req, res) {
    var self = this;
    var temp_qrcode = qr_image.imageSync(req.key, { 'type': 'png' });
    var buffer = new Buffer(temp_qrcode, 'binary');
    res.url = 'data: image/png;base64,' + buffer.toString('base64');
    self.end(res);
};