var Service = require('Service');
var util = require('util');
var utils = require('utils');
var Dao = require('Dao');

/**
 * 获得默认UI风格
 */
var GetConsoleInfo = function () {
    Service.call(this);
};

util.inherits(GetConsoleInfo, Service);

module.exports = GetConsoleInfo;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetConsoleInfo.prototype.process = function (req, res) {
    res.sysName = server.config.SysName;
    res.sysLogo = server.config.SysLogo;
    res.homePage = server.config.HomePage;
    res.curUser = {
        id: req.session.userId,
        code: req.session.userCode,
        name: req.session.userName,
        loginname: req.session.userLoginname,
        sex: req.session.userSex,
        headId: req.session.userHeadId,
        deps: req.session.userDeps,
        roles: req.session.userRoles,
        orgId: req.session.orgId
    };

    var ctype = 'web';
    if (req.clientType) ctype = req.clientType.toLowerCase();

    var clientType = 'web';
    if (ctype == 'pc') {
        clientType = 'pc';
    } else if (ctype.indexOf('phone') >= 0) {
        clientType = 'phone';
    } else if (ctype.indexOf('pad') >= 0) {
        clientType = 'pad';
    }

    var self = this;
    req.session.cache.exec({
        userId: req.session.userId,
        clientType: clientType
    }, function (cacheData, args) {
        var curUser = cacheData['user'].values[args.userId];
        //获得所有人角色
        var roleAllUser = null;
        for (roleId in cacheData['role'].values) {
            var role = cacheData['role'].values[roleId];
            if (role.name == '所有人') {
                roleAllUser = role;
                break;
            }
        }
        //获得应用权限信息
        var authsModel = cacheData['app_auth'];
        var auths = [];
        for (var j = 0; j < authsModel.keys.length; j++) {
            var auth = authsModel.values[authsModel.keys[j]];
            if (!auth.opration_id && (!auth.terminal || auth.terminal.indexOf(args.clientType) >= 0)) {
                auths.push({
                    app_id: auth.app_id,
                    owner_id: auth.owner_id,
                    owner_type: auth.owner_type
                });
            }
        }

        var categoryModel = cacheData['app_category'];
        var rootCategorys = [];
        
        for(var k=0;k<categoryModel.keys.length;k++) {
            var category = categoryModel.values[categoryModel.keys[k]];
            if(!category.apps || category.apps.length==0) continue;

            var haveAuth = false;
            for (var i = 0; i < category.apps.length; i++) {
                let appId = category.apps[i];
                for (var j = 0; j < auths.length; j++) {
                    var auth = auths[j];
                    if (auth.app_id != appId) continue;
                    if (auth.owner_type == 'user' && auth.owner_id == args.userId) {
                        haveAuth = true;
                        break;
                    } else if (auth.owner_type == 'dep' && curUser.deps.contains(auth.owner_id)) {
                        haveAuth = true;
                        break;
                    } else if (auth.owner_type == 'role' && (curUser.roles.contains(auth.owner_id)
                        || (roleAllUser && auth.owner_id == roleAllUser.id))) {
                        haveAuth = true;
                        break;
                    }
                }
                if(haveAuth) break;
            }
            if(haveAuth) {
                let rootCategory = null;
                if(category.parent_id==0) {
                    rootCategory = category;
                } else {
                    var parentId = category.parent_id;
                    while(parentId!=0) {
                        var parent = categoryModel.values[parentId];
                        if(!parent) break;
                        parentId = parent.parent_id;
                        if(parentId==0) rootCategory = parent;
                    }
                }
                if(rootCategory) {
                    let isExists = false;
                    for(var i=0;i<rootCategorys.length;i++) {
                        var c = rootCategorys[i];
                        if(c.id==rootCategory.id) {
                            isExists = true;
                            break;
                        }
                    }
                    if(!isExists) {
                        rootCategorys.push({
                            id: rootCategory.id,
                            name: rootCategory.name,
                            order_no: rootCategory.order_no,
                            icon_code: rootCategory.icon_code
                        });
                    }
                }
            }
        }
        return rootCategorys;
    }, function (err, rootCategorys) {
        if (err) {
            console.log(err);
            return;
        }

        rootCategorys.sort(utils.compare('order_no'));

        res.rootCategorys = rootCategorys;
        if (rootCategorys.length == 0) {
            res.categorys = {};
            res.apps = {};
            res.subCategorys = [];
            res.appIds = [];
            self.end(res);
            return;
        }

        req.categoryId = rootCategorys[0].id;
        self.pipe(require('./app/getMyAppsByCategory'), req, res, function (req1, res1) {
            self.end(res1);
        });
    });
};