var Service = require('Service');
var utils = require('utils');
var util = require('util');
var fs = require('fs');
var Dao = require('Dao');


// 钉钉上传  新建空间
var Uploadfile = function () {
    Service.call(this);
    this._dao = new Dao(this);
    this.checkLogin = false;
    this.checkAuthority = false;
};

util.inherits(Uploadfile, Service);

module.exports = Uploadfile;
Uploadfile.prototype.process = function (req, res) {
    var self = this;
    if (!req.filepath) {
        this.onLogicError(1, '请提供文件路径！', req, res);
        return;
    }
    fs.readFile('./app/' + req.filepath + '/setting.json', 'utf-8', function (err, data) {
        if (err) console.log(err);
        if (!data) {
            self.onLogicError(1, '文件不存在！', req, res);
            return;
        }
        req.appkey = JSON.parse(data).dd.appkey;
        req.appsecret = JSON.parse(data).dd.appsecret;
        res.agentid = JSON.parse(data).dd.agentid;
        if (!server.cache[req.appkey]) {
            self.getToken(req, res);
        } else {
            var dingInfo = server.cache[req.appkey];
            var oldTime = dingInfo.expires_time;
            if (oldTime) {
                var newTime = new Date().getTime();
                //判断上一次获取access_token时间是否超过7000秒，超过重新获取access_token
                if (newTime - oldTime > 7000 * 1000) {
                    self.getToken(req, res);
                } else {
                    if (dingInfo.access_token) {
                        req.access_token = dingInfo.access_token;
                        self.getfileingo(req, res);
                    } else {
                        self.getToken(req, res);
                    }
                }
            } else {
                self.getToken(req, res);
            }
        }
    });
}

// 获取应用token
Uploadfile.prototype.getToken = function (req, res) {
    var self = this;
    let appkey = req.appkey; // 应用appkey
    let appsecret = req.appsecret; // 应用appsecret
    let url = `https://oapi.dingtalk.com/gettoken?appkey=${appkey}&appsecret=${appsecret}`;
    self.sendHttpRequest({
        "method": "get",
        "urlPath": url,
        "retToJson": true
    }, function (reqHttp, resHttp, err, data) {
        console.log("data", data)
        data = JSON.parse(data);
        if (!err && data.errcode == 0) {
            var obj = {
                access_token: data.access_token,
                expires_time: new Date().getTime()
            }
            server.cache[req.appkey] = obj;
            req.access_token = data.access_token;
            logger.log("获取应用token", req.access_token);
            self.getfileingo(req, res);
        } else {
            res.code = -1;
            res.message = data.sub_msg;
            self.end(res);
        }
    });
}

// 获取文件详细
Uploadfile.prototype.getfileingo = function (req, res) {
    var self = this;
    let params = [];
    params.push(req.filecode);
    self._dao.execute(
        "select * from sys_app_attach where code = ? limit 1", params,
        function (rows) {
            if (rows) {
                res.filedata = rows[0];
                self.uploadfile(req, res);
            } else {
                res.code = -1;
                self.end(res);
            }
        });
}

// 通过token 上传文件
Uploadfile.prototype.uploadfile = function (req, res) {
    var self = this;
    // var filename = new Date().getTime();
    // let url = `https://oapi.dingtalk.com/file/upload/single?access_token=${req.access_token}&agent_id=${req.agentid}&file_size=${res.filedata.size}`;
    let url = `https://oapi.dingtalk.com/media/upload?access_token=${req.access_token}`;

    // var file = new File([], res.filedata.save_path, { lastModified: new Date() });
    
    self.sendHttpRequest({
        "method": "post",
        "urlPath": url,
        "retToJson": true,
        "postdata": { type:'file',media: `E:/TB01/tasgine/files`+res.filedata.save_path }
    }, function (reqHttp, resHttp, err, data) {
        // data = JSON.parse(data);
        if (!err && data.errcode == 0) {
            logger.log("通过token 上传文件", data);
            res.data = data;
            self.end(res);
        }else{
            res.code = -1;
            res.message = data.errcode;
            self.end(res);
        }
    });
}