var Service = require('Service');
var utils = require('utils');
var util = require('util');
var fs = require('fs')

// 钉钉上传  结束上传
var getOauth2Dingtalk = function () {
    Service.call(this);
    this.checkLogin = false;
    this.checkAuthority = false;
};

util.inherits(getOauth2Dingtalk, Service);

module.exports = getOauth2Dingtalk;
getOauth2Dingtalk.prototype.process = function (req, res) {
    var self = this;
    if (!req.filepath) {
        this.onLogicError(1, '请提供文件路径！', req, res);
        return;
    }
    fs.readFile('./app/' + req.filepath + '/setting.json', 'utf-8', function (err, data) {
        if (err) console.log(err);
        if (!data) {
            self.onLogicError(1, '文件不存在！', req, res);
            return;
        }
        req.appkey = JSON.parse(data).dd.appkey;
        req.appsecret = JSON.parse(data).dd.appsecret;
        req.agentid = JSON.parse(data).dd.agentid;
        if (!server.cache[req.appkey]) {
            self.getToken(req, res);
        } else {
            var dingInfo = server.cache[req.appkey];
            var oldTime = dingInfo.expires_time;
            if (oldTime) {
                var newTime = new Date().getTime();
                //判断上一次获取access_token时间是否超过7000秒，超过重新获取access_token
                if (newTime - oldTime > 7000 * 1000) {
                    self.getToken(req, res);
                } else {
                    if (dingInfo.access_token) {
                        req.access_token = dingInfo.access_token;
                        self.getspaces(req, res);
                    } else {
                        self.getToken(req, res);
                    }
                }
            } else {
                self.getToken(req, res);
            }
        }
    });
}
// 获取应用token
getOauth2Dingtalk.prototype.getToken = function (req, res) {
    var self = this;
    let appkey = req.appkey; // 应用appkey
    let appsecret = req.appsecret; // 应用appsecret
    let url = `https://oapi.dingtalk.com/gettoken?appkey=${appkey}&appsecret=${appsecret}`;
    self.sendHttpRequest({
        "method": "get",
        "urlPath": url,
        "retToJson": true
    }, function (reqHttp, resHttp, err, data) {
        console.log("data", data)
        data = JSON.parse(data);
        if (!err && data.errcode == 0) {
            var obj = {
                access_token: data.access_token,
                expires_time: new Date().getTime()
            }
            server.cache[req.appkey] = obj;
            req.access_token = data.access_token;
            logger.log("获取应用token", req.access_token);
            self.getspaces(req, res);
        } else {
            res.code = -1;
            res.message = data.sub_msg;
            self.end(res);
        }
    });
}

// 通过token和unionid 从钉盘获取url
getOauth2Dingtalk.prototype.getspaces = function (req, res) {
    var self = this;
    var unionid = req.unionid;
    let url = `https://api.dingtalk.com/v1.0/drive/spaces/${req.spaceid}/files/${req.dentryId}/downloadInfos?x-acs-dingtalk-access-token=${req.access_token}&unionId=${unionid}`;
    self.sendHttpRequest({
        "method": "get",
        "urlPath": url,
        "retToJson": true,
    }, function (reqHttp, resHttp, err, data) {
        data = JSON.parse(data);
        console.log(req.access_token)
        logger.log("通过token和unionid 从钉盘获取url", data);
        res.space = data;
        self.end(res);
    });
}