var Service = require('Service')
var util = require('util')
var utils = require('utils')
var Dao = require('Dao')

/**
 * Sys_datadic_type_Update
 * 修改sys_datadic_type
 */
var Sys_datadic_type_Update = function () {
  Service.call(this)
  this._dao = new Dao(this)
}

util.inherits(Sys_datadic_type_Update, Service)

module.exports = Sys_datadic_type_Update

/**
 * 处理服务请求
 * @param  {object} req 服务请求对象
 * @param  {object} res 服务响应对象
 */
Sys_datadic_type_Update.prototype.process = function (req, res) {
  //请求参数校验
  if (utils.isNull(req.id)) {
    this.onLogicError(1, '请提供参数[id]！')
    return
  }
  if (!utils.isNull(req.id) && !utils.isInt(req.id)) {
    this.onLogicError(2, '参数[id]格式不正确！')
    return
  }

  var self = this
  let params = [];
  params.push(req.name);
  self._dao.execute(
    "select name from sys_datadic_type where  name=?", params,
    function(data) {
    if(data.length>0) {
      self.onLogicError(1, "类别名称已经存在！");
      return;
    }
  let obj = {}
  obj['name'] = null
  if (!utils.isNull(req.name)) obj['name'] = req.name + ''
  obj['parent_id'] = null
  if (utils.isNull(req.parent_id)) {
    obj['parent_id'] = 0
  } else if (!utils.isNull(req.parent_id)) {
    obj['parent_id'] = parseInt(req.parent_id)
  }
  let options = {
    where: 'id=?',
    params: [req.id]
  }
  self._dao.model = server.loadModule('/app/sys/model/sys_datadic_type.tdm')
  self._dao.update(obj, options, function () {
    self.end(res)
  });
 });
}
