var Service = require('Service')
var util = require('util')
var utils = require('utils')
var Dao = require('Dao')

/**
 * Sys_datadic_type_Add
 * 添加sys_datadic_type
 */
var Sys_datadic_type_Add = function () {
  Service.call(this)
  this._dao = new Dao(this)
}

util.inherits(Sys_datadic_type_Add, Service)

module.exports = Sys_datadic_type_Add

/**
 * 处理服务请求
 * @param  {object} req 服务请求对象
 * @param  {object} res 服务响应对象
 */
Sys_datadic_type_Add.prototype.process = function (req, res) {
  var self = this
  let params = [];
  params.push(req.name);
  self._dao.execute(
    "select name from sys_datadic_type where  name=?", params,
    function(data) {
    if(data.length>0) {
      self.onLogicError(1, "类别名称已经存在！");
      return;
    }
  let obj = {}
  if (!utils.isNull(req.name)) obj['name'] = req.name + ''
  if (utils.isNull(req.parent_id)) {
    obj['parent_id'] = 0
  } else if (!utils.isNull(req.parent_id)) {
    obj['parent_id'] = parseInt(req.parent_id)
  }
  self._dao.model = server.loadModule('/app/sys/model/sys_datadic_type.tdm')
  self._dao.create(obj, function (ret) {
    res.id = ret.insertId
    self.end(res)
  });
 });
}
